/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   case_item.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/case_item.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/pattern_expr_group.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* case_item::GetByVpiName(std::string_view name) const {
  if (vpiExprs_ != nullptr) {
    for (const BaseClass *ref : *vpiExprs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((stmt_ != nullptr) && (stmt_->VpiName().compare(name) == 0)) {
    return stmt_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> case_item::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(nullptr, uhdmvpiExprs, (const std::vector<const BaseClass*>*)vpiExprs_);
    case vpiStmt: return std::make_tuple(stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

case_item::vpi_property_value_t case_item::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void case_item::DeepCopy(case_item* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterCase_item(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = VpiExprs()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiExprs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveCase_item(clone, nullptr);
}

case_item* case_item::DeepClone(BaseClass* parent, CloneContext* context) const {
  case_item* const clone = context->m_serializer->MakeCase_item();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t case_item::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->VpiExprs(), rhs, rhs->VpiExprs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Stmt(), rhs->Stmt(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
