/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   case_stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/case_stmt.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/case_item.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* case_stmt::GetByVpiName(std::string_view name) const {
  if ((vpiCondition_ != nullptr) && (vpiCondition_->VpiName().compare(name) == 0)) {
    return vpiCondition_;
  }
  if (case_items_ != nullptr) {
    for (const BaseClass *ref : *case_items_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> case_stmt::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCaseItem: return std::make_tuple(nullptr, uhdmcase_items, (const std::vector<const BaseClass*>*)case_items_);
    case vpiCondition: return std::make_tuple(vpiCondition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

case_stmt::vpi_property_value_t case_stmt::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiCaseType: return vpi_property_value_t(VpiCaseType());
    case vpiQualifier: return vpi_property_value_t(VpiQualifier());
    case vpiRandType: return vpi_property_value_t(VpiRandType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void case_stmt::DeepCopy(case_stmt* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterCase_stmt(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiCondition()) clone->VpiCondition(obj->DeepClone(clone, context));
  if (auto vec = Case_items()) {
    auto clone_vec = context->m_serializer->MakeCase_itemVec();
    clone->Case_items(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveCase_stmt(clone, nullptr);
}

case_stmt* case_stmt::DeepClone(BaseClass* parent, CloneContext* context) const {
  case_stmt* const clone = context->m_serializer->MakeCase_stmt();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t case_stmt::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiRandType() - rhs->VpiRandType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiCaseType() - rhs->VpiCaseType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiQualifier() - rhs->VpiQualifier()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->VpiCondition(), rhs->VpiCondition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Case_items(), rhs, rhs->Case_items(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
