/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   checker_decl.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/checker_decl.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/checker_port.h>
#include <uhdm/clocking_block.h>
#include <uhdm/cont_assign.h>
#include <uhdm/process_stmt.h>


namespace UHDM {
const BaseClass* checker_decl::GetByVpiName(std::string_view name) const {
  if ((default_clocking_ != nullptr) && (default_clocking_->VpiName().compare(name) == 0)) {
    return default_clocking_;
  }
  if (process_ != nullptr) {
    for (const BaseClass *ref : *process_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (cont_assigns_ != nullptr) {
    for (const BaseClass *ref : *cont_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (ports_ != nullptr) {
    for (const BaseClass *ref : *ports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> checker_decl::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiContAssign: return std::make_tuple(nullptr, uhdmcont_assigns, (const std::vector<const BaseClass*>*)cont_assigns_);
    case vpiDefaultClocking: return std::make_tuple(default_clocking_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPort: return std::make_tuple(nullptr, uhdmports, (const std::vector<const BaseClass*>*)ports_);
    case vpiProcess: return std::make_tuple(nullptr, uhdmprocess, (const std::vector<const BaseClass*>*)process_);
  }
  return basetype_t::GetByVpiType(type);
}

checker_decl::vpi_property_value_t checker_decl::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void checker_decl::DeepCopy(checker_decl* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterChecker_decl(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Default_clocking()) clone->Default_clocking(obj->DeepClone(clone, context));
  if (auto vec = Process()) {
    auto clone_vec = context->m_serializer->MakeProcess_stmtVec();
    clone->Process(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Cont_assigns()) {
    auto clone_vec = context->m_serializer->MakeCont_assignVec();
    clone->Cont_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Ports()) {
    auto clone_vec = context->m_serializer->MakeChecker_portVec();
    clone->Ports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveChecker_decl(clone, nullptr);
}

checker_decl* checker_decl::DeepClone(BaseClass* parent, CloneContext* context) const {
  checker_decl* const clone = context->m_serializer->MakeChecker_decl();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t checker_decl::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Default_clocking(), rhs->Default_clocking(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Process(), rhs, rhs->Process(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Cont_assigns(), rhs, rhs->Cont_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ports(), rhs, rhs->Ports(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
