/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   checker_inst_port.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/checker_inst_port.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/property_inst.h>
#include <uhdm/sequence_inst.h>


namespace UHDM {
const BaseClass* checker_inst_port::GetByVpiName(std::string_view name) const {
  if ((property_ != nullptr) && (property_->VpiName().compare(name) == 0)) {
    return property_;
  }
  if ((sequence_ != nullptr) && (sequence_->VpiName().compare(name) == 0)) {
    return sequence_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> checker_inst_port::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiPropertyInst: return std::make_tuple(property_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiSequenceInst: return std::make_tuple(sequence_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

checker_inst_port::vpi_property_value_t checker_inst_port::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void checker_inst_port::DeepCopy(checker_inst_port* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterChecker_inst_port(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Property()) clone->Property(obj->DeepClone(clone, context));
  if (auto obj = Sequence()) clone->Sequence(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveChecker_inst_port(clone, nullptr);
}

checker_inst_port* checker_inst_port::DeepClone(BaseClass* parent, CloneContext* context) const {
  checker_inst_port* const clone = context->m_serializer->MakeChecker_inst_port();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t checker_inst_port::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Property(), rhs->Property(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Sequence(), rhs->Sequence(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
