/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   class_defn.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/class_defn.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/class_defn.h>
#include <uhdm/class_typespec.h>
#include <uhdm/constraint.h>
#include <uhdm/extends.h>
#include <uhdm/task_func.h>


namespace UHDM {
std::string_view class_defn::VpiEndLabel() const {
  return vpiEndLabel_ ? serializer_->GetSymbol(vpiEndLabel_) : kEmpty;
}

bool class_defn::VpiEndLabel(std::string_view data) {
  vpiEndLabel_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* class_defn::GetByVpiName(std::string_view name) const {
  if ((extends_ != nullptr) && (extends_->VpiName().compare(name) == 0)) {
    return extends_;
  }
  if (task_funcs_ != nullptr) {
    for (const BaseClass *ref : *task_funcs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (constraints_ != nullptr) {
    for (const BaseClass *ref : *constraints_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (deriveds_ != nullptr) {
    for (const BaseClass *ref : *deriveds_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (class_typespecs_ != nullptr) {
    for (const BaseClass *ref : *class_typespecs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> class_defn::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClassTypespec: return std::make_tuple(nullptr, uhdmclass_typespecs, (const std::vector<const BaseClass*>*)class_typespecs_);
    case vpiConstraint: return std::make_tuple(nullptr, uhdmconstraints, (const std::vector<const BaseClass*>*)constraints_);
    case vpiDerivedClasses: return std::make_tuple(nullptr, uhdmderiveds, (const std::vector<const BaseClass*>*)deriveds_);
    case vpiExtends: return std::make_tuple(extends_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiMethod: return std::make_tuple(nullptr, uhdmtask_funcs, (const std::vector<const BaseClass*>*)task_funcs_);
  }
  return basetype_t::GetByVpiType(type);
}

class_defn::vpi_property_value_t class_defn::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiAutomatic: return vpi_property_value_t(VpiAutomatic());
    case vpiEndLabel: {
      std::string_view data = VpiEndLabel();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
    case vpiVirtual: return vpi_property_value_t(VpiVirtual());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void class_defn::DeepCopy(class_defn* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterClass_defn(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Extends()) clone->Extends(obj->DeepClone(clone, context));
  if (auto vec = Task_funcs()) {
    auto clone_vec = context->m_serializer->MakeTask_funcVec();
    clone->Task_funcs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Constraints()) {
    auto clone_vec = context->m_serializer->MakeConstraintVec();
    clone->Constraints(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Deriveds()) {
    auto clone_vec = context->m_serializer->MakeClass_defnVec();
    clone->Deriveds(clone_vec);
    clone_vec->insert(clone_vec->cend(), vec->cbegin(), vec->cend());
  }
  if (auto vec = Class_typespecs()) {
    auto clone_vec = context->m_serializer->MakeClass_typespecVec();
    clone->Class_typespecs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveClass_defn(clone, nullptr);
}

class_defn* class_defn::DeepClone(BaseClass* parent, CloneContext* context) const {
  class_defn* const clone = context->m_serializer->MakeClass_defn();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t class_defn::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiVirtual() == rhs->VpiVirtual()) ? 0 : (lhs->VpiVirtual() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiAutomatic() == rhs->VpiAutomatic()) ? 0 : (lhs->VpiAutomatic() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Extends(), rhs->Extends(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Task_funcs(), rhs, rhs->Task_funcs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Constraints(), rhs, rhs->Constraints(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Deriveds(), rhs, rhs->Deriveds(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Class_typespecs(), rhs, rhs->Class_typespecs(), context)) != 0) return r;
  if ((r = lhs->VpiEndLabel().compare(rhs->VpiEndLabel())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
