/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   class_obj.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/class_obj.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/constraint.h>
#include <uhdm/expr.h>
#include <uhdm/ref_typespec.h>
#include <uhdm/task_func.h>
#include <uhdm/thread_obj.h>


namespace UHDM {
const BaseClass* class_obj::GetByVpiName(std::string_view name) const {
  if ((class_typespec_ != nullptr) && (class_typespec_->VpiName().compare(name) == 0)) {
    return class_typespec_;
  }
  if (threads_ != nullptr) {
    for (const BaseClass *ref : *threads_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (messages_ != nullptr) {
    for (const BaseClass *ref : *messages_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (task_funcs_ != nullptr) {
    for (const BaseClass *ref : *task_funcs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (constraints_ != nullptr) {
    for (const BaseClass *ref : *constraints_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> class_obj::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClassTypespec: return std::make_tuple(class_typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiConstraint: return std::make_tuple(nullptr, uhdmconstraints, (const std::vector<const BaseClass*>*)constraints_);
    case vpiMessages: return std::make_tuple(nullptr, uhdmmessages, (const std::vector<const BaseClass*>*)messages_);
    case vpiTaskFunc: return std::make_tuple(nullptr, uhdmtask_funcs, (const std::vector<const BaseClass*>*)task_funcs_);
    case vpiWaitingProcesses: return std::make_tuple(nullptr, uhdmthreads, (const std::vector<const BaseClass*>*)threads_);
  }
  return basetype_t::GetByVpiType(type);
}

class_obj::vpi_property_value_t class_obj::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiObjId: return vpi_property_value_t(VpiObjId());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void class_obj::DeepCopy(class_obj* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterClass_obj(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Class_typespec()) clone->Class_typespec(obj->DeepClone(clone, context));
  if (auto vec = Threads()) {
    auto clone_vec = context->m_serializer->MakeThread_objVec();
    clone->Threads(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Messages()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Messages(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Task_funcs()) {
    auto clone_vec = context->m_serializer->MakeTask_funcVec();
    clone->Task_funcs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Constraints()) {
    auto clone_vec = context->m_serializer->MakeConstraintVec();
    clone->Constraints(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveClass_obj(clone, nullptr);
}

class_obj* class_obj::DeepClone(BaseClass* parent, CloneContext* context) const {
  class_obj* const clone = context->m_serializer->MakeClass_obj();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t class_obj::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiObjId() - rhs->VpiObjId()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Class_typespec(), rhs->Class_typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Threads(), rhs, rhs->Threads(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Messages(), rhs, rhs->Messages(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Task_funcs(), rhs, rhs->Task_funcs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Constraints(), rhs, rhs->Constraints(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
