/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   class_typespec.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/class_typespec.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/class_defn.h>
#include <uhdm/constraint.h>
#include <uhdm/named_event.h>
#include <uhdm/named_event_array.h>
#include <uhdm/param_assign.h>
#include <uhdm/parameters.h>
#include <uhdm/ref_typespec.h>
#include <uhdm/scope.h>
#include <uhdm/task_func.h>
#include <uhdm/variables.h>
#include <uhdm/virtual_interface_var.h>


namespace UHDM {
const BaseClass* class_typespec::GetByVpiName(std::string_view name) const {
  if ((extends_ != nullptr) && (extends_->VpiName().compare(name) == 0)) {
    return extends_;
  }
  if (variables_ != nullptr) {
    for (const BaseClass *ref : *variables_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (task_funcs_ != nullptr) {
    for (const BaseClass *ref : *task_funcs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (constraints_ != nullptr) {
    for (const BaseClass *ref : *constraints_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (parameters_ != nullptr) {
    for (const BaseClass *ref : *parameters_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (param_assigns_ != nullptr) {
    for (const BaseClass *ref : *param_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (virtual_interface_vars_ != nullptr) {
    for (const BaseClass *ref : *virtual_interface_vars_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (named_events_ != nullptr) {
    for (const BaseClass *ref : *named_events_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (named_event_arrays_ != nullptr) {
    for (const BaseClass *ref : *named_event_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (scopes_ != nullptr) {
    for (const BaseClass *ref : *scopes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((class_defn_ != nullptr) && (class_defn_->VpiName().compare(name) == 0)) {
    return class_defn_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> class_typespec::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClassDefn: return std::make_tuple(class_defn_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiConstraint: return std::make_tuple(nullptr, uhdmconstraints, (const std::vector<const BaseClass*>*)constraints_);
    case vpiExtends: return std::make_tuple(extends_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInternalScope: return std::make_tuple(nullptr, uhdmscopes, (const std::vector<const BaseClass*>*)scopes_);
    case vpiMethod: return std::make_tuple(nullptr, uhdmtask_funcs, (const std::vector<const BaseClass*>*)task_funcs_);
    case vpiNamedEvent: return std::make_tuple(nullptr, uhdmnamed_events, (const std::vector<const BaseClass*>*)named_events_);
    case vpiNamedEventArray: return std::make_tuple(nullptr, uhdmnamed_event_arrays, (const std::vector<const BaseClass*>*)named_event_arrays_);
    case vpiParamAssign: return std::make_tuple(nullptr, uhdmparam_assigns, (const std::vector<const BaseClass*>*)param_assigns_);
    case vpiParameter: return std::make_tuple(nullptr, uhdmparameters, (const std::vector<const BaseClass*>*)parameters_);
    case vpiVariables: return std::make_tuple(nullptr, uhdmvariables, (const std::vector<const BaseClass*>*)variables_);
    case vpiVirtualInterfaceVar: return std::make_tuple(nullptr, uhdmvirtual_interface_vars, (const std::vector<const BaseClass*>*)virtual_interface_vars_);
  }
  return basetype_t::GetByVpiType(type);
}

class_typespec::vpi_property_value_t class_typespec::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiAutomatic: return vpi_property_value_t(VpiAutomatic());
    case vpiClassType: return vpi_property_value_t(VpiClassType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void class_typespec::DeepCopy(class_typespec* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterClass_typespec(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Extends()) clone->Extends(obj->DeepClone(clone, context));
  if (auto vec = Variables()) {
    auto clone_vec = context->m_serializer->MakeVariablesVec();
    clone->Variables(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Task_funcs()) {
    auto clone_vec = context->m_serializer->MakeTask_funcVec();
    clone->Task_funcs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Constraints()) {
    auto clone_vec = context->m_serializer->MakeConstraintVec();
    clone->Constraints(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Parameters()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Parameters(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Param_assigns()) {
    auto clone_vec = context->m_serializer->MakeParam_assignVec();
    clone->Param_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Virtual_interface_vars()) {
    auto clone_vec = context->m_serializer->MakeVirtual_interface_varVec();
    clone->Virtual_interface_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_events()) {
    auto clone_vec = context->m_serializer->MakeNamed_eventVec();
    clone->Named_events(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_event_arrays()) {
    auto clone_vec = context->m_serializer->MakeNamed_event_arrayVec();
    clone->Named_event_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Scopes()) {
    auto clone_vec = context->m_serializer->MakeScopeVec();
    clone->Scopes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Class_defn()) clone->Class_defn((class_defn*) obj);
  elaboratorContext->m_elaborator.leaveClass_typespec(clone, nullptr);
}

class_typespec* class_typespec::DeepClone(BaseClass* parent, CloneContext* context) const {
  class_typespec* const clone = context->m_serializer->MakeClass_typespec();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t class_typespec::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiClassType() - rhs->VpiClassType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiAutomatic() == rhs->VpiAutomatic()) ? 0 : (lhs->VpiAutomatic() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Extends(), rhs->Extends(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Variables(), rhs, rhs->Variables(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Task_funcs(), rhs, rhs->Task_funcs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Constraints(), rhs, rhs->Constraints(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Parameters(), rhs, rhs->Parameters(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Param_assigns(), rhs, rhs->Param_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Virtual_interface_vars(), rhs, rhs->Virtual_interface_vars(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Named_events(), rhs, rhs->Named_events(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Named_event_arrays(), rhs, rhs->Named_event_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Scopes(), rhs, rhs->Scopes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Class_defn(), rhs->Class_defn(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
