/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   class_var.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/class_var.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/class_obj.h>


namespace UHDM {
const BaseClass* class_var::GetByVpiName(std::string_view name) const {
  if ((class_obj_ != nullptr) && (class_obj_->VpiName().compare(name) == 0)) {
    return class_obj_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> class_var::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClassObj: return std::make_tuple(class_obj_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

class_var::vpi_property_value_t class_var::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiObjId: return vpi_property_value_t(VpiObjId());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void class_var::DeepCopy(class_var* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterClass_var(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Class_obj()) clone->Class_obj(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveClass_var(clone, nullptr);
}

class_var* class_var::DeepClone(BaseClass* parent, CloneContext* context) const {
  class_var* const clone = context->m_serializer->MakeClass_var();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t class_var::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiObjId() - rhs->VpiObjId()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Class_obj(), rhs->Class_obj(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
