/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   clocked_property.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/clocked_property.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/property_expr_group.h>


namespace UHDM {
const BaseClass* clocked_property::GetByVpiName(std::string_view name) const {
  if ((vpiClockingEvent_ != nullptr) && (vpiClockingEvent_->VpiName().compare(name) == 0)) {
    return vpiClockingEvent_;
  }
  if ((vpiPropertyExpr_ != nullptr) && (vpiPropertyExpr_->VpiName().compare(name) == 0)) {
    return vpiPropertyExpr_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> clocked_property::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClockingEvent: return std::make_tuple(vpiClockingEvent_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPropertyExpr: return std::make_tuple(vpiPropertyExpr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

clocked_property::vpi_property_value_t clocked_property::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void clocked_property::DeepCopy(clocked_property* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterClocked_property(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiClockingEvent()) clone->VpiClockingEvent(obj->DeepClone(clone, context));
  if (auto obj = VpiPropertyExpr()) clone->VpiPropertyExpr(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveClocked_property(clone, nullptr);
}

clocked_property* clocked_property::DeepClone(BaseClass* parent, CloneContext* context) const {
  clocked_property* const clone = context->m_serializer->MakeClocked_property();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t clocked_property::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->VpiClockingEvent(), rhs->VpiClockingEvent(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiPropertyExpr(), rhs->VpiPropertyExpr(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
