/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   clocking_block.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/clocking_block.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>
#include <uhdm/clocking_io_decl.h>
#include <uhdm/delay_control.h>
#include <uhdm/event_control.h>
#include <uhdm/instance.h>
#include <uhdm/virtual_interface_var.h>


namespace UHDM {
const BaseClass* clocking_block::GetByVpiName(std::string_view name) const {
  if ((input_skew_ != nullptr) && (input_skew_->VpiName().compare(name) == 0)) {
    return input_skew_;
  }
  if ((output_skew_ != nullptr) && (output_skew_->VpiName().compare(name) == 0)) {
    return output_skew_;
  }
  if ((clocking_event_ != nullptr) && (clocking_event_->VpiName().compare(name) == 0)) {
    return clocking_event_;
  }
  if ((instance_ != nullptr) && (instance_->VpiName().compare(name) == 0)) {
    return instance_;
  }
  if (clocking_io_decls_ != nullptr) {
    for (const BaseClass *ref : *clocking_io_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((prefix_ != nullptr) && (prefix_->VpiName().compare(name) == 0)) {
    return prefix_;
  }
  if ((actual_ != nullptr) && (actual_->VpiName().compare(name) == 0)) {
    return actual_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> clocking_block::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiActual: return std::make_tuple(actual_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiClockingEvent: return std::make_tuple(clocking_event_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiClockingIODecl: return std::make_tuple(nullptr, uhdmclocking_io_decls, (const std::vector<const BaseClass*>*)clocking_io_decls_);
    case vpiInputSkew: return std::make_tuple(input_skew_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInstance: return std::make_tuple(instance_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiOutputSkew: return std::make_tuple(output_skew_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPrefix: return std::make_tuple(prefix_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

clocking_block::vpi_property_value_t clocking_block::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiInputEdge: return vpi_property_value_t(VpiInputEdge());
    case vpiOutputEdge: return vpi_property_value_t(VpiOutputEdge());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void clocking_block::DeepCopy(clocking_block* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterClocking_block(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Input_skew()) clone->Input_skew(obj->DeepClone(clone, context));
  if (auto obj = Output_skew()) clone->Output_skew(obj->DeepClone(clone, context));
  if (auto obj = Clocking_event()) clone->Clocking_event(obj->DeepClone(clone, context));
  if (auto obj = Instance()) clone->Instance((instance*) obj);
  if (instance* inst = any_cast<instance*>(parent))
    clone->Instance(inst);
  if (auto vec = Clocking_io_decls()) {
    auto clone_vec = context->m_serializer->MakeClocking_io_declVec();
    clone->Clocking_io_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Prefix()) clone->Prefix(obj->DeepClone(clone, context));
  if (auto obj = Actual()) clone->Actual(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveClocking_block(clone, nullptr);
}

clocking_block* clocking_block::DeepClone(BaseClass* parent, CloneContext* context) const {
  clocking_block* const clone = context->m_serializer->MakeClocking_block();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t clocking_block::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiInputEdge() - rhs->VpiInputEdge()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiOutputEdge() - rhs->VpiOutputEdge()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Input_skew(), rhs->Input_skew(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Output_skew(), rhs->Output_skew(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Clocking_event(), rhs->Clocking_event(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Instance(), rhs->Instance(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Clocking_io_decls(), rhs, rhs->Clocking_io_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Prefix(), rhs->Prefix(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Actual(), rhs->Actual(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
