/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   clocking_io_decl.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/clocking_io_decl.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/delay_control.h>
#include <uhdm/nets_vars_ref_obj_group.h>


namespace UHDM {
std::string_view clocking_io_decl::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool clocking_io_decl::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* clocking_io_decl::GetByVpiName(std::string_view name) const {
  if ((input_skew_ != nullptr) && (input_skew_->VpiName().compare(name) == 0)) {
    return input_skew_;
  }
  if ((output_skew_ != nullptr) && (output_skew_->VpiName().compare(name) == 0)) {
    return output_skew_;
  }
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> clocking_io_decl::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInputSkew: return std::make_tuple(input_skew_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiOutputSkew: return std::make_tuple(output_skew_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

clocking_io_decl::vpi_property_value_t clocking_io_decl::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDirection: return vpi_property_value_t(VpiDirection());
    case vpiInputEdge: return vpi_property_value_t(VpiInputEdge());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiOutputEdge: return vpi_property_value_t(VpiOutputEdge());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void clocking_io_decl::DeepCopy(clocking_io_decl* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterClocking_io_decl(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Input_skew()) clone->Input_skew(obj->DeepClone(clone, context));
  if (auto obj = Output_skew()) clone->Output_skew(obj->DeepClone(clone, context));
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveClocking_io_decl(clone, nullptr);
}

clocking_io_decl* clocking_io_decl::DeepClone(BaseClass* parent, CloneContext* context) const {
  clocking_io_decl* const clone = context->m_serializer->MakeClocking_io_decl();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t clocking_io_decl::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiDirection() - rhs->VpiDirection()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiInputEdge() - rhs->VpiInputEdge()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiOutputEdge() - rhs->VpiOutputEdge()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Input_skew(), rhs->Input_skew(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Output_skew(), rhs->Output_skew(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
