/*
 Do not modify, auto-generated by script

 Copyright 2019-2020 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   clone_tree.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ExprEval.h>
#include <uhdm/clone_tree.h>
#include <uhdm/uhdm.h>

namespace UHDM {

BaseClass* clone_tree(const BaseClass* root, CloneContext* context) {
  return root ? root->DeepClone(nullptr, context) : nullptr;
}

tf_call* sys_func_call::DeepClone(BaseClass* parent,
                                  CloneContext* context) const {
  sys_func_call* const clone = context->m_serializer->MakeSys_func_call();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  clone->VpiParent(parent);
  if (auto obj = User_systf())
    clone->User_systf(obj->DeepClone(clone, context));
  if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
  if (auto vec = Tf_call_args()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Tf_call_args(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));

  return clone;
}

tf_call* sys_task_call::DeepClone(BaseClass* parent,
                                  CloneContext* context) const {
  sys_task_call* const clone = context->m_serializer->MakeSys_task_call();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  clone->VpiParent(parent);
  if (auto obj = User_systf())
    clone->User_systf(obj->DeepClone(clone, context));
  if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
  if (auto vec = Tf_call_args()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Tf_call_args(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));

  return clone;
}

tf_call* method_func_call::DeepClone(BaseClass* parent,
                                     CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  const expr* prefix = Prefix();
  if (prefix) {
    prefix = prefix->DeepClone((BaseClass*)this, context);
  }
  bool is_function =
      elaboratorContext->m_elaborator.isFunctionCall(VpiName(), prefix);
  tf_call* the_clone = nullptr;
  if (is_function) {
    method_func_call* const clone =
        context->m_serializer->MakeMethod_func_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    *clone = *this;
    clone->UhdmId(id);
    clone->VpiParent(parent);
    if (auto obj = Prefix()) clone->Prefix(obj->DeepClone(clone, context));
    const ref_obj* ref = any_cast<const ref_obj*>(clone->Prefix());
    const class_var* varprefix = nullptr;
    if (ref) varprefix = any_cast<const class_var*>(ref->Actual_group());
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, varprefix);
    any* pushedVar = nullptr;
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        any* arg = obj->DeepClone(clone, context);
        // CB callbacks_to_append[$];
        // unique_callbacks_to_append = callbacks_to_append.unique( cb_ )
        // with ( cb_.get_inst_id );
        if (parent->UhdmType() == UHDM_OBJECT_TYPE::uhdmhier_path) {
          hier_path* phier = (hier_path*)parent;
          any* last = phier->Path_elems()->back();
          if (ref_obj* last_ref = any_cast<ref_obj*>(last)) {
            if (const any* actual = last_ref->Actual_group()) {
              if (ref_obj* refarg = any_cast<ref_obj*>(arg)) {
                bool override = false;
                if (const any* act = refarg->Actual_group()) {
                  if (act->VpiName() == obj->VpiName()) {
                    override = true;
                  }
                } else {
                  override = true;
                }
                if (override) {
                  if (actual->UhdmType() == UHDM_OBJECT_TYPE::uhdmarray_var) {
                    array_var* arr = (array_var*)actual;
                    if (arr->Variables() && !arr->Variables()->empty()) {
                      variables* var = arr->Variables()->front();
                      if (variables* varclone =
                              (variables*)clone_tree(var, context)) {
                        varclone->VpiName(obj->VpiName());
                        varclone->VpiParent(const_cast<any*>(obj->VpiParent()));
                        actual = varclone;
                        elaboratorContext->m_elaborator.pushVar(varclone);
                        pushedVar = varclone;
                      }
                    }
                  }
                  refarg->Actual_group((any*)actual);
                }
              }
            }
          }
        }
        clone_vec->push_back(arg);
      }
    }
    if (auto obj = With()) clone->With(obj->DeepClone(clone, context));
    if (pushedVar) {
      elaboratorContext->m_elaborator.popVar(pushedVar);
    }
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  } else {
    method_task_call* const clone =
        context->m_serializer->MakeMethod_task_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    //*clone = *this;
    clone->VpiName(VpiName());
    clone->Tf_call_args(Tf_call_args());
    clone->UhdmId(id);
    clone->VpiParent(parent);
    clone->VpiFile(VpiFile());
    clone->VpiLineNo(VpiLineNo());
    clone->VpiColumnNo(VpiColumnNo());
    clone->VpiEndLineNo(VpiEndLineNo());
    clone->VpiEndColumnNo(VpiEndColumnNo());
    if (auto obj = Prefix()) clone->Prefix(obj->DeepClone(clone, context));
    const ref_obj* ref = any_cast<const ref_obj*>(clone->Prefix());
    const class_var* varprefix = nullptr;
    if (ref) varprefix = any_cast<const class_var*>(ref->Actual_group());
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, varprefix);
    if (auto obj = With()) clone->With(obj->DeepClone(clone, context));
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      }
    }
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  }
  return the_clone;
}

constant* constant::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  if (elaboratorContext->m_elaborator.uniquifyTypespec() || (VpiSize() == -1)) {
    constant* const clone = context->m_serializer->MakeConstant();
    const uint32_t id = clone->UhdmId();
    *clone = *this;
    clone->UhdmId(id);
    clone->VpiParent(parent);
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
    return clone;
  } else {
    return (constant*)this;
  }
}

tagged_pattern* tagged_pattern::DeepClone(BaseClass* parent,
                                          CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  if (elaboratorContext->m_elaborator.uniquifyTypespec()) {
    tagged_pattern* const clone = context->m_serializer->MakeTagged_pattern();
    const uint32_t id = clone->UhdmId();
    *clone = *this;
    clone->UhdmId(id);
    clone->VpiParent(parent);
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
    if (auto obj = Pattern()) clone->Pattern(obj->DeepClone(clone, context));
    return clone;
  } else {
    return (tagged_pattern*)this;
  }
}

tf_call* method_task_call::DeepClone(BaseClass* parent,
                                     CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  const expr* prefix = Prefix();
  if (prefix) {
    prefix = prefix->DeepClone((BaseClass*)this, context);
  }
  bool is_task = elaboratorContext->m_elaborator.isTaskCall(VpiName(), prefix);
  tf_call* the_clone = nullptr;
  if (is_task) {
    method_task_call* const clone =
        context->m_serializer->MakeMethod_task_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    *clone = *this;
    clone->UhdmId(id);
    clone->VpiParent(parent);
    if (auto obj = Prefix()) clone->Prefix(obj->DeepClone(clone, context));
    const ref_obj* ref = any_cast<const ref_obj*>(clone->Prefix());
    const class_var* varprefix = nullptr;
    if (ref) varprefix = any_cast<const class_var*>(ref->Actual_group());
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, varprefix);
    if (auto obj = With()) clone->With(obj->DeepClone(clone, context));
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      }
    }
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  } else {
    method_func_call* const clone =
        context->m_serializer->MakeMethod_func_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    //*clone = *this;
    clone->VpiName(VpiName());
    clone->Tf_call_args(Tf_call_args());
    clone->UhdmId(id);
    clone->VpiParent(parent);
    clone->VpiFile(VpiFile());
    clone->VpiLineNo(VpiLineNo());
    clone->VpiColumnNo(VpiColumnNo());
    clone->VpiEndLineNo(VpiEndLineNo());
    clone->VpiEndColumnNo(VpiEndColumnNo());
    if (auto obj = Prefix()) clone->Prefix(obj->DeepClone(clone, context));
    const ref_obj* ref = any_cast<const ref_obj*>(clone->Prefix());
    const class_var* varprefix = nullptr;
    if (ref) varprefix = any_cast<const class_var*>(ref->Actual_group());
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, varprefix);
    if (auto obj = With()) clone->With(obj->DeepClone(clone, context));
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      }
    }
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  }
  return the_clone;
}

tf_call* func_call::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  bool is_function =
      elaboratorContext->m_elaborator.isFunctionCall(VpiName(), nullptr);
  tf_call* the_clone = nullptr;
  if (is_function) {
    func_call* const clone = context->m_serializer->MakeFunc_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    *clone = *this;
    clone->UhdmId(id);
    clone->VpiParent(parent);
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, nullptr);
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      }
    }
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  } else {
    task_call* const clone = context->m_serializer->MakeTask_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    //*clone = *this;
    clone->VpiName(VpiName());
    clone->Tf_call_args(Tf_call_args());
    clone->UhdmId(id);
    clone->VpiParent(parent);
    clone->VpiFile(VpiFile());
    clone->VpiLineNo(VpiLineNo());
    clone->VpiColumnNo(VpiColumnNo());
    clone->VpiEndLineNo(VpiEndLineNo());
    clone->VpiEndColumnNo(VpiEndColumnNo());
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, nullptr);
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      }
    }
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  }

  return the_clone;
}

tf_call* task_call::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  bool is_task = elaboratorContext->m_elaborator.isTaskCall(VpiName(), nullptr);
  tf_call* the_clone = nullptr;
  if (is_task) {
    task_call* const clone = context->m_serializer->MakeTask_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    *clone = *this;
    clone->UhdmId(id);
    clone->VpiParent(parent);
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, nullptr);
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      }
    }
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  } else {
    func_call* const clone = context->m_serializer->MakeFunc_call();
    the_clone = clone;
    const uint32_t id = clone->UhdmId();
    //*clone = *this;
    clone->VpiName(VpiName());
    clone->VpiFile(VpiFile());
    clone->VpiLineNo(VpiLineNo());
    clone->VpiColumnNo(VpiColumnNo());
    clone->VpiEndLineNo(VpiEndLineNo());
    clone->VpiEndColumnNo(VpiEndColumnNo());
    clone->Tf_call_args(Tf_call_args());
    clone->UhdmId(id);
    clone->VpiParent(parent);
    elaboratorContext->m_elaborator.scheduleTaskFuncBinding(clone, nullptr);
    if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
    if (auto vec = Tf_call_args()) {
      auto clone_vec = context->m_serializer->MakeAnyVec();
      clone->Tf_call_args(clone_vec);
      for (auto obj : *vec) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      }
    }
    if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  }
  return the_clone;
}

gen_scope_array* gen_scope_array::DeepClone(BaseClass* parent,
                                            CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  gen_scope_array* const clone = context->m_serializer->MakeGen_scope_array();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  clone->VpiParent(parent);
  if (auto obj = Gen_var()) clone->Gen_var(obj->DeepClone(clone, context));
  if (auto vec = Gen_scopes()) {
    auto clone_vec = context->m_serializer->MakeGen_scopeVec();
    clone->Gen_scopes(clone_vec);
    for (auto obj : *vec) {
      elaboratorContext->m_elaborator.enterGen_scope(obj, nullptr);
      clone_vec->push_back(obj->DeepClone(clone, context));
      elaboratorContext->m_elaborator.leaveGen_scope(obj, nullptr);
    }
  }
  if (auto obj = VpiInstance())
    clone->VpiInstance(obj->DeepClone(clone, context));

  return clone;
}

function* function::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  function* const clone = context->m_serializer->MakeFunction();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  clone->VpiParent(parent);
  if (auto obj = Left_range())
    clone->Left_range(obj->DeepClone(clone, context));
  if (auto obj = Right_range())
    clone->Right_range(obj->DeepClone(clone, context));
  if (auto obj = Return()) clone->Return((variables*)obj);
  if (auto obj = Instance()) clone->Instance((instance*)obj);
  if (instance* inst = any_cast<instance*>(parent)) clone->Instance(inst);
  if (auto obj = Class_defn())
    clone->Class_defn(obj->DeepClone(clone, context));
  if (auto vec = Io_decls()) {
    auto clone_vec = context->m_serializer->MakeIo_declVec();
    clone->Io_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Variables()) {
    auto clone_vec = context->m_serializer->MakeVariablesVec();
    clone->Variables(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Parameters()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Parameters(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Scopes()) {
    auto clone_vec = context->m_serializer->MakeScopeVec();
    clone->Scopes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Typespecs()) {
    auto clone_vec = context->m_serializer->MakeTypespecVec();
    clone->Typespecs(clone_vec);
    for (auto obj : *vec) {
      if (elaboratorContext->m_elaborator.uniquifyTypespec()) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      } else {
        clone_vec->push_back(obj);
      }
    }
  }
  elaboratorContext->m_elaborator.enterTask_func(clone, nullptr);
  if (auto vec = Concurrent_assertions()) {
    auto clone_vec = context->m_serializer->MakeConcurrent_assertionsVec();
    clone->Concurrent_assertions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Property_decls()) {
    auto clone_vec = context->m_serializer->MakeProperty_declVec();
    clone->Property_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Sequence_decls()) {
    auto clone_vec = context->m_serializer->MakeSequence_declVec();
    clone->Sequence_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_events()) {
    auto clone_vec = context->m_serializer->MakeNamed_eventVec();
    clone->Named_events(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_event_arrays()) {
    auto clone_vec = context->m_serializer->MakeNamed_event_arrayVec();
    clone->Named_event_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Virtual_interface_vars()) {
    auto clone_vec = context->m_serializer->MakeVirtual_interface_varVec();
    clone->Virtual_interface_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Logic_vars()) {
    auto clone_vec = context->m_serializer->MakeLogic_varVec();
    clone->Logic_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_vars()) {
    auto clone_vec = context->m_serializer->MakeArray_varVec();
    clone->Array_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_var_mems()) {
    auto clone_vec = context->m_serializer->MakeArray_varVec();
    clone->Array_var_mems(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Param_assigns()) {
    auto clone_vec = context->m_serializer->MakeParam_assignVec();
    clone->Param_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Let_decls()) {
    auto clone_vec = context->m_serializer->MakeLet_declVec();
    clone->Let_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Instance_items()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Instance_items(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveTask_func(clone, nullptr);
  return clone;
}

task* task::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  task* const clone = context->m_serializer->MakeTask();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  clone->VpiParent(parent);
  if (auto obj = Left_range())
    clone->Left_range(obj->DeepClone(clone, context));
  if (auto obj = Right_range())
    clone->Right_range(obj->DeepClone(clone, context));
  if (auto obj = Return()) clone->Return(obj->DeepClone(clone, context));
  if (auto obj = Instance()) clone->Instance((instance*)obj);
  if (instance* inst = any_cast<instance*>(parent)) clone->Instance(inst);
  if (auto obj = Class_defn())
    clone->Class_defn(obj->DeepClone(clone, context));
  if (auto vec = Io_decls()) {
    auto clone_vec = context->m_serializer->MakeIo_declVec();
    clone->Io_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Variables()) {
    auto clone_vec = context->m_serializer->MakeVariablesVec();
    clone->Variables(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Scopes()) {
    auto clone_vec = context->m_serializer->MakeScopeVec();
    clone->Scopes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Typespecs()) {
    auto clone_vec = context->m_serializer->MakeTypespecVec();
    clone->Typespecs(clone_vec);
    for (auto obj : *vec) {
      if (elaboratorContext->m_elaborator.uniquifyTypespec()) {
        clone_vec->push_back(obj->DeepClone(clone, context));
      } else {
        clone_vec->push_back(obj);
      }
    }
  }
  elaboratorContext->m_elaborator.enterTask_func(clone, nullptr);
  if (auto vec = Concurrent_assertions()) {
    auto clone_vec = context->m_serializer->MakeConcurrent_assertionsVec();
    clone->Concurrent_assertions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Property_decls()) {
    auto clone_vec = context->m_serializer->MakeProperty_declVec();
    clone->Property_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Sequence_decls()) {
    auto clone_vec = context->m_serializer->MakeSequence_declVec();
    clone->Sequence_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_events()) {
    auto clone_vec = context->m_serializer->MakeNamed_eventVec();
    clone->Named_events(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_event_arrays()) {
    auto clone_vec = context->m_serializer->MakeNamed_event_arrayVec();
    clone->Named_event_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Virtual_interface_vars()) {
    auto clone_vec = context->m_serializer->MakeVirtual_interface_varVec();
    clone->Virtual_interface_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Logic_vars()) {
    auto clone_vec = context->m_serializer->MakeLogic_varVec();
    clone->Logic_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_vars()) {
    auto clone_vec = context->m_serializer->MakeArray_varVec();
    clone->Array_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_var_mems()) {
    auto clone_vec = context->m_serializer->MakeArray_varVec();
    clone->Array_var_mems(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Param_assigns()) {
    auto clone_vec = context->m_serializer->MakeParam_assignVec();
    clone->Param_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Let_decls()) {
    auto clone_vec = context->m_serializer->MakeLet_declVec();
    clone->Let_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Parameters()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Parameters(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Instance_items()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Instance_items(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveTask_func(clone, nullptr);
  return clone;
}

cont_assign* cont_assign::DeepClone(BaseClass* parent,
                                    CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  cont_assign* const clone = context->m_serializer->MakeCont_assign();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  clone->VpiParent(parent);
  if (auto obj = Delay()) clone->Delay(obj->DeepClone(clone, context));
  expr* lhs = nullptr;
  if (auto obj = Lhs()) {
    lhs = obj->DeepClone(clone, context);
    if (lhs->UhdmType() == uhdmhier_path) {
      hier_path* path = (hier_path*) lhs;
      any* last = path->Path_elems()->back();
      if (ref_obj* ro = any_cast<ref_obj*>(last)) {
        if (net* n = any_cast<net*>(ro->Actual_group())) {
          // The net parent has to be the same as a current scope
          if (n->VpiParent() == parent)
            lhs = n;
        } 
      }
    }
    clone->Lhs(lhs);
  }
  if (auto obj = Rhs()) {
    expr* rhs = obj->DeepClone(clone, context);
    if (rhs->UhdmType() == uhdmhier_path) {
      hier_path* path = (hier_path*) rhs;
      any* last = path->Path_elems()->back();
      if (ref_obj* ro = any_cast<ref_obj*>(last)) {
        if (constant* c = any_cast<constant*>(ro->Actual_group())) {
          // The constant parrent's parent has to be the same as a current scope
          if (c->VpiParent()->VpiParent() == parent)
            rhs = c;
        } 
      }
    }
    clone->Rhs(rhs);
    if (ref_obj* ro = any_cast<ref_obj*>(lhs)) {
      if (struct_var* stv = ro->Actual_group<struct_var>()) {
        if (ref_typespec* rt = stv->Typespec()) {
          if (typespec* ts = rt->Actual_typespec()) {
            ExprEval eval(elaboratorContext->m_elaborator.muteErrors());
            if (expr* res = eval.flattenPatternAssignments(
                    *context->m_serializer, ts, rhs)) {
              if (res->UhdmType() == UHDM_OBJECT_TYPE::uhdmoperation) {
                ((operation*)rhs)->Operands(((operation*)res)->Operands());
              }
            }
          }
        }
      }
    }
  }
  if (auto vec = Cont_assign_bits()) {
    auto clone_vec = context->m_serializer->MakeCont_assign_bitVec();
    clone->Cont_assign_bits(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }

  return clone;
}

any* bindClassTypespec(class_typespec* ctps, any* current,
                       std::string_view name, bool& found) {
  any* previous = nullptr;
  const class_defn* defn = ctps->Class_defn();
  while (defn) {
    if (defn->Variables()) {
      for (variables* var : *defn->Variables()) {
        if (var->VpiName() == name) {
          if (ref_obj* ro = any_cast<ref_obj*>(current)) {
            ro->Actual_group(var);
          }
          previous = var;
          found = true;
          break;
        }
      }
    }
    if (defn->Named_events()) {
      for (named_event* event : *defn->Named_events()) {
        if (event->VpiName() == name) {
          if (ref_obj* ro = any_cast<ref_obj*>(current)) {
            ro->Actual_group(event);
          }
          previous = event;
          found = true;
          break;
        }
      }
    }
    if (defn->Task_funcs()) {
      for (task_func* tf : *defn->Task_funcs()) {
        if (tf->VpiName() == name) {
          if (ref_obj* ro = any_cast<ref_obj*>(current)) {
            ro->Actual_group(tf);
          } else if (current->UhdmType() ==
                     UHDM_OBJECT_TYPE::uhdmmethod_func_call) {
            if (tf->UhdmType() == UHDM_OBJECT_TYPE::uhdmfunction)
              ((method_func_call*)current)->Function((function*)tf);
          } else if (current->UhdmType() ==
                     UHDM_OBJECT_TYPE::uhdmmethod_task_call) {
            if (tf->UhdmType() == UHDM_OBJECT_TYPE::uhdmtask)
              ((method_task_call*)current)->Task((task*)tf);
          }
          previous = tf;
          found = true;
          break;
        }
      }
    }
    if (found) break;

    const class_defn* base_defn = nullptr;
    if (const extends* ext = defn->Extends()) {
      if (const ref_typespec* rt = ext->Class_typespec()) {
        if (const class_typespec* tp = rt->Actual_typespec<class_typespec>()) {
          base_defn = tp->Class_defn();
        }
      }
    }
    defn = base_defn;
  }
  return previous;
}

hier_path* hier_path::DeepClone(BaseClass* parent,
                                CloneContext* context) const {
  ElaboratorContext* const elaboratorContext =
      clonecontext_cast<ElaboratorContext*>(context);
  hier_path* const clone = context->m_serializer->MakeHier_path();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  clone->VpiParent(parent);
  if (auto vec = Path_elems()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Path_elems(clone_vec);
    any* previous = nullptr;
    for (auto obj : *vec) {
      any* current = obj->DeepClone(clone, context);
      clone_vec->push_back(current);
      bool found = false;
      if (ref_obj* ref = any_cast<ref_obj*>(current)) {
        if (current->VpiName() == "this") {
          const any* tmp = current;
          while (tmp) {
            if (tmp->UhdmType() == UHDM_OBJECT_TYPE::uhdmclass_defn) {
              ref->Actual_group((any*)tmp);
              found = true;
              break;
            }
            tmp = tmp->VpiParent();
          }
        } else if (current->VpiName() == "super") {
          const any* tmp = current;
          while (tmp) {
            if (tmp->UhdmType() == UHDM_OBJECT_TYPE::uhdmclass_defn) {
              class_defn* def = (class_defn*)tmp;
              if (const extends* ext = def->Extends()) {
                if (const ref_typespec* rt = ext->Class_typespec()) {
                  if (const class_typespec* ctps =
                          rt->Actual_typespec<class_typespec>()) {
                    ref->Actual_group((any*)ctps->Class_defn());
                    found = true;
                    break;
                  }
                }
              }
              break;
            }
            tmp = tmp->VpiParent();
          }
        }
      }
      if (previous) {
        std::string_view name = obj->VpiName();
        if (name.empty() || name.find('[') == 0) {
          if (ref_obj* ro = any_cast<ref_obj*>(obj)) {
            if (const any* actual = ro->Actual_group()) {
              name = actual->VpiName();
            }
            //  a[i][j]
            if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmbit_select) {
              bit_select* prev = (bit_select*)previous;
              ro->Actual_group((any*)prev->Actual_group());
              found = true;
            }
          }
        }
        std::string nameIndexed(name);
        if (obj->UhdmType() == UHDM_OBJECT_TYPE::uhdmbit_select) {
          bit_select* bs = static_cast<bit_select*>(obj);
          const expr* index = bs->VpiIndex();
          std::string_view indexName = index->VpiDecompile();
          if (!indexName.empty()) {
            nameIndexed.append("[").append(indexName).append("]");
          }
        }
        if (ref_obj* pro = any_cast<ref_obj*>(previous)) {
          const any* actual = pro->Actual_group();
          if ((actual == nullptr) && (previous->VpiName() == "$root")) {
            actual = elaboratorContext->m_elaborator.currentDesign();
          }
          if (actual) {
            UHDM_OBJECT_TYPE actual_type = actual->UhdmType();
            switch (actual_type) {
              case UHDM_OBJECT_TYPE::uhdmdesign: {
                design* scope = (design*)actual;
                if (scope->TopModules()) {
                  for (auto m : *scope->TopModules()) {
                    const std::string_view modName = m->VpiName();
                    if (modName == name || modName == nameIndexed ||
                        modName == std::string("work@").append(name)) {
                      found = true;
                      previous = m;
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(m);
                      }
                      break;
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmgen_scope: {
                gen_scope* scope = (gen_scope*)actual;
                if (obj->UhdmType() == UHDM_OBJECT_TYPE::uhdmmethod_func_call) {
                  method_func_call* call = (method_func_call*)current;
                  if (scope->Task_funcs()) {
                    for (auto tf : *scope->Task_funcs()) {
                      if (tf->VpiName() == name) {
                        call->Function(any_cast<function*>(tf));
                        previous = (any*)call->Function();
                        found = true;
                        break;
                      }
                    }
                  }
                } else if (obj->UhdmType() ==
                           UHDM_OBJECT_TYPE::uhdmmethod_task_call) {
                  method_task_call* call = (method_task_call*)current;
                  if (scope->Task_funcs()) {
                    for (auto tf : *scope->Task_funcs()) {
                      if (tf->VpiName() == name) {
                        call->Task(any_cast<task*>(tf));
                        found = true;
                        previous = (any*)call->Task();
                        break;
                      }
                    }
                  }
                } else {
                  if (!found && scope->Modules()) {
                    for (auto m : *scope->Modules()) {
                      if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                        found = true;
                        previous = m;
                        if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                          cro->Actual_group(m);
                        }
                        break;
                      }
                    }
                  }
                  if (!found && scope->Nets()) {
                    for (auto m : *scope->Nets()) {
                      if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                        found = true;
                        previous = m;
                        if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                          cro->Actual_group(m);
                        }
                        break;
                      }
                    }
                  }
                  if (!found && scope->Array_nets()) {
                    for (auto m : *scope->Array_nets()) {
                      if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                        found = true;
                        previous = m;
                        if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                          cro->Actual_group(m);
                        }
                        break;
                      }
                    }
                  }
                  if (!found && scope->Variables()) {
                    for (auto m : *scope->Variables()) {
                      if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                        found = true;
                        previous = m;
                        if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                          cro->Actual_group(m);
                        }
                        break;
                      }
                    }
                  }
                  if (!found && scope->Gen_scope_arrays()) {
                    for (auto gsa : *scope->Gen_scope_arrays()) {
                      if (gsa->VpiName() == name ||
                          gsa->VpiName() == nameIndexed) {
                        if (!gsa->Gen_scopes()->empty()) {
                          auto gs = gsa->Gen_scopes()->front();
                          if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                            cro->Actual_group(gs);
                          }
                          previous = gs;
                          found = true;
                        }
                      }
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmmodport: {
                modport* mp = (modport*)actual;
                if (mp->Io_decls()) {
                  for (io_decl* decl : *mp->Io_decls()) {
                    if (decl->VpiName() == name) {
                      found = true;
                      previous = decl;
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(decl);
                      }
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmnamed_event: {
                if (name == "triggered") {
                  // Builtin
                  found = true;
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmarray_net: {
                array_net* anet = (array_net*)actual;
                VectorOfnet* vars = anet->Nets();
                if (vars && vars->size()) {
                  actual = vars->at(0);
                  actual_type = actual->UhdmType();
                }
                if (name == "size" || name == "exists" || name == "find" ||
                    name == "max" || name == "min") {
                  func_call* call = context->m_serializer->MakeFunc_call();
                  call->VpiName(name);
                  call->VpiParent(clone);
                  if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                    cro->Actual_group(call);
                  }
                  // Builtin method
                  found = true;
                  previous = (any*)call;
                } else if (name == "") {
                  // One of the Index(es)
                  found = true;
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmarray_var:
              case UHDM_OBJECT_TYPE::uhdmpacked_array_var: {
                const typespec* tps = nullptr;
                if (actual_type == UHDM_OBJECT_TYPE::uhdmpacked_array_var) {
                  packed_array_var* avar = (packed_array_var*)actual;
                  if (VectorOfany* vars = avar->Elements()) {
                    if (!vars->empty()) {
                      actual = vars->front();
                      actual_type = actual->UhdmType();
                    }
                  }
                  if (const ref_typespec* rt = avar->Typespec()) {
                    tps = rt->Actual_typespec();
                    if (const packed_array_typespec* ptps =
                            rt->Actual_typespec<packed_array_typespec>()) {
                      if (const ref_typespec* ert = ptps->Elem_typespec()) {
                        tps = ert->Actual_typespec();
                      }
                    }
                  }
                } else {
                  array_var* avar = (array_var*)actual;
                  if (VectorOfvariables* vars = avar->Variables()) {
                    if (!vars->empty()) {
                      actual = vars->front();
                      actual_type = actual->UhdmType();
                    }
                  }
                  if (const ref_typespec* rt = avar->Typespec()) {
                    tps = rt->Actual_typespec();
                    if (const array_typespec* atps =
                            rt->Actual_typespec<array_typespec>()) {
                      if (const ref_typespec* ert = atps->Elem_typespec()) {
                        tps = ert->Actual_typespec();
                      }
                    }
                  }
                }
                if (name == "size" || name == "exists" || name == "find" ||
                    name == "max" || name == "min") {
                  func_call* call = context->m_serializer->MakeFunc_call();
                  call->VpiName(name);
                  call->VpiParent(clone);
                  if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                    cro->Actual_group(call);
                  }
                  // Builtin method
                  found = true;
                  previous = (any*)call;
                }
                if (found == false) {
                  if (tps) {
                    UHDM_OBJECT_TYPE ttype = tps->UhdmType();
                    if (ttype == UHDM_OBJECT_TYPE::uhdmpacked_array_typespec) {
                      packed_array_typespec* ptps = (packed_array_typespec*)tps;
                      tps = (typespec*)ptps->Elem_typespec();
                      if (tps) ttype = tps->UhdmType();
                    } else if (ttype == UHDM_OBJECT_TYPE::uhdmarray_typespec) {
                      array_typespec* ptps = (array_typespec*)tps;
                      tps = (typespec*)ptps->Elem_typespec();
                      if (tps) ttype = tps->UhdmType();
                    }
                    if (ttype == UHDM_OBJECT_TYPE::uhdmstring_typespec) {
                      found = true;
                    } else if (ttype == UHDM_OBJECT_TYPE::uhdmclass_typespec) {
                      class_typespec* ctps = (class_typespec*)tps;
                      any* tmp = bindClassTypespec(ctps, current, name, found);
                      if (found) {
                        previous = tmp;
                      }
                    } else if (ttype == UHDM_OBJECT_TYPE::uhdmstruct_typespec) {
                      struct_typespec* stpt = (struct_typespec*)tps;
                      for (typespec_member* member : *stpt->Members()) {
                        if (member->VpiName() == name) {
                          if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                            cro->Actual_group(member);
                          }
                          previous = member;
                          found = true;
                          break;
                        }
                      }
                      if (name == "name") {
                        // Builtin introspection
                        found = true;
                      }
                    } else if (ttype == UHDM_OBJECT_TYPE::uhdmenum_typespec) {
                      if (name == "name") {
                        // Builtin introspection
                        found = true;
                      }
                    } else if (ttype == UHDM_OBJECT_TYPE::uhdmunion_typespec) {
                      union_typespec* stpt = (union_typespec*)tps;
                      for (typespec_member* member : *stpt->Members()) {
                        if (member->VpiName() == name) {
                          if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                            cro->Actual_group(member);
                          }
                          previous = member;
                          found = true;
                          break;
                        }
                      }
                      if (name == "name") {
                        // Builtin introspection
                        found = true;
                      }
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmpacked_array_net: {
                packed_array_net* avar = (packed_array_net*)actual;
                VectorOfany* vars = avar->Elements();
                if (vars && vars->size()) {
                  actual = vars->at(0);
                  actual_type = actual->UhdmType();
                }
                if (name == "size" || name == "exists" || name == "exists" ||
                    name == "max" || name == "min") {
                  func_call* call = context->m_serializer->MakeFunc_call();
                  call->VpiName(name);
                  call->VpiParent(clone);
                  if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                    cro->Actual_group(call);
                  }
                  // Builtin method
                  found = true;
                  previous = (any*)call;
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmnamed_begin: {
                named_begin* begin = (named_begin*)actual;
                if (!found && begin->Variables()) {
                  for (auto m : *begin->Variables()) {
                    if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                      found = true;
                      previous = m;
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(m);
                      }
                      break;
                    }
                  }
                }
                if (!found && begin->Array_vars()) {
                  for (auto m : *begin->Array_vars()) {
                    if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                      found = true;
                      previous = m;
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(m);
                      }
                      break;
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmnamed_fork: {
                named_fork* begin = (named_fork*)actual;
                if (!found && begin->Variables()) {
                  for (auto m : *begin->Variables()) {
                    if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                      found = true;
                      previous = m;
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(m);
                      }
                      break;
                    }
                  }
                }
                if (!found && begin->Array_vars()) {
                  for (auto m : *begin->Array_vars()) {
                    if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                      found = true;
                      previous = m;
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(m);
                      }
                      break;
                    }
                  }
                }
                break;
              }
              default:
                break;
            }

            switch (actual_type) {
              case UHDM_OBJECT_TYPE::uhdmclocking_block: {
                clocking_block* block = (clocking_block*)actual;
                if (block->Clocking_io_decls()) {
                  for (clocking_io_decl* decl : *block->Clocking_io_decls()) {
                    if (decl->VpiName() == name) {
                      found = true;
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(decl);
                      }
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmmodule_inst: {
                module_inst* mod = (module_inst*)actual;
                if (!found && mod->Variables()) {
                  for (variables* var : *mod->Variables()) {
                    if (var->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(var);
                      }
                      previous = var;
                      found = true;
                      break;
                    }
                  }
                }
                if (!found && mod->Nets()) {
                  for (nets* n : *mod->Nets()) {
                    if (n->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(n);
                      }
                      previous = n;
                      found = true;
                      break;
                    }
                  }
                }
                if (!found && mod->Modules()) {
                  for (auto m : *mod->Modules()) {
                    if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                      found = true;
                      previous = m;
                      break;
                    }
                  }
                }
                if (!found && mod->Interfaces()) {
                  for (auto m : *mod->Interfaces()) {
                    if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                      found = true;
                      previous = m;
                      break;
                    }
                  }
                }
                if (!found && mod->Gen_scope_arrays()) {
                  for (auto gsa : *mod->Gen_scope_arrays()) {
                    if (gsa->VpiName() == name ||
                        gsa->VpiName() == nameIndexed) {
                      if (!gsa->Gen_scopes()->empty()) {
                        auto gs = gsa->Gen_scopes()->front();
                        if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                          cro->Actual_group(gs);
                        }
                        previous = gs;
                        found = true;
                      }
                    }
                  }
                }
                if (!found && mod->Task_funcs()) {
                  for (auto tsf : *mod->Task_funcs()) {
                    if (tsf->VpiName() == name ||
                        tsf->VpiName() == nameIndexed) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(tsf);
                      }
                      previous = tsf;
                      found = true;
                    }
                  }
                }
                if (!found && mod->Param_assigns()) {
                  for (auto pa : *mod->Param_assigns()) {
                    if (pa->Lhs()->VpiName() == name ||
                        pa->Lhs()->VpiName() == nameIndexed) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(pa->Rhs());
                      }
                      previous = pa;
                      found = true;
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmclass_var: {
                const typespec* tps = nullptr;
                if (const ref_typespec* rt = ((class_var*)actual)->Typespec()) {
                  tps = rt->Actual_typespec();
                }
                if (tps == nullptr) break;
                UHDM_OBJECT_TYPE ttype = tps->UhdmType();
                if (ttype == UHDM_OBJECT_TYPE::uhdmclass_typespec) {
                  class_typespec* ctps = (class_typespec*)tps;
                  any* tmp = bindClassTypespec(ctps, current, name, found);
                  if (found) {
                    previous = tmp;
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmstruct_typespec) {
                  struct_typespec* stpt = (struct_typespec*)tps;
                  for (typespec_member* member : *stpt->Members()) {
                    if (member->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(member);
                      }
                      previous = member;
                      found = true;
                      break;
                    }
                  }
                }
                if (current->UhdmType() ==
                    UHDM_OBJECT_TYPE::uhdmmethod_func_call) {
                  found = true;
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmstruct_net:
              case UHDM_OBJECT_TYPE::uhdmstruct_var: {
                VectorOftypespec_member* members = nullptr;
                if (actual->UhdmType() == UHDM_OBJECT_TYPE::uhdmstruct_net) {
                  if (ref_typespec* rt = ((struct_net*)actual)->Typespec()) {
                    if (struct_typespec* sts =
                            rt->Actual_typespec<struct_typespec>()) {
                      members = sts->Members();
                    } else if (union_typespec* uts =
                                   rt->Actual_typespec<union_typespec>()) {
                      members = uts->Members();
                    }
                  }
                } else if (actual->UhdmType() ==
                           UHDM_OBJECT_TYPE::uhdmstruct_var) {
                  if (ref_typespec* rt = ((struct_var*)actual)->Typespec()) {
                    if (struct_typespec* sts =
                            rt->Actual_typespec<struct_typespec>()) {
                      members = sts->Members();
                    }
                  }
                }
                if (members) {
                  for (typespec_member* member : *members) {
                    if (member->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(member);
                      }
                      previous = member;
                      found = true;
                      break;
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmunion_var: {
                union_typespec* stpt = nullptr;
                if (ref_typespec* rt = ((union_var*)actual)->Typespec()) {
                  stpt = rt->Actual_typespec<union_typespec>();
                }
                if (stpt == nullptr) break;
                for (typespec_member* member : *stpt->Members()) {
                  if (member->VpiName() == name) {
                    if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                      cro->Actual_group(member);
                    }
                    previous = member;
                    found = true;
                    break;
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdminterface_inst: {
                interface_inst* interf = (interface_inst*)actual;
                if (!found && interf->Variables()) {
                  for (variables* var : *interf->Variables()) {
                    if (var->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(var);
                      }
                      previous = var;
                      found = true;
                      break;
                    }
                  }
                }
                if (!found && interf->Parameters()) {
                  for (any* var : *interf->Parameters()) {
                    if (var->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(var);
                      }
                      previous = var;
                      found = true;
                      break;
                    }
                  }
                }
                if (!found && interf->Task_funcs()) {
                  for (auto tf : *interf->Task_funcs()) {
                    if (tf->VpiName() == name) {
                      previous = any_cast<function*>(tf);
                      found = true;
                      break;
                    }
                  }
                }
                if (!found && interf->Modports()) {
                  for (modport* mport : *interf->Modports()) {
                    if (mport->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(mport);
                      }
                      previous = mport;
                      found = true;
                      break;
                    }
                    if (mport->Io_decls()) {
                      for (io_decl* decl : *mport->Io_decls()) {
                        if (decl->VpiName() == name) {
                          any* actual_decl = decl;
                          if (any* exp = decl->Expr()) {
                            actual_decl = exp;
                          }
                          if (actual_decl->UhdmType() ==
                              UHDM_OBJECT_TYPE::uhdmref_obj) {
                            ref_obj* ref = (ref_obj*)actual_decl;
                            if (const any* act = ref->Actual_group()) {
                              actual_decl = (any*)act;
                            }
                          }
                          if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                            cro->Actual_group(actual_decl);
                          }
                          previous = actual_decl;
                          found = true;
                          break;
                        }
                      }
                    }
                    if (found) break;
                  }
                }
                if (!found && interf->Nets()) {
                  for (nets* n : *interf->Nets()) {
                    if (n->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(n);
                      }
                      previous = n;
                      found = true;
                      break;
                    }
                  }
                }
                if (!found && interf->Ports()) {
                  for (port* p : *interf->Ports()) {
                    if (p->VpiName() == name) {
                      if (any* ref = p->Low_conn()) {
                        if (ref_obj* nref = any_cast<ref_obj*>(ref)) {
                          any* n = nref->Actual_group();
                          if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                            cro->Actual_group(n);
                          }
                          previous = n;
                          found = true;
                          break;
                        }
                      }
                    }
                  }
                }
                if (!found && interf->Gen_scope_arrays()) {
                  for (auto gsa : *interf->Gen_scope_arrays()) {
                    if (gsa->VpiName() == name ||
                        gsa->VpiName() == nameIndexed) {
                      if (!gsa->Gen_scopes()->empty()) {
                        auto gs = gsa->Gen_scopes()->front();
                        if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                          cro->Actual_group(gs);
                        }
                        previous = gs;
                        found = true;
                      }
                    }
                  }
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmarray_var: {
                if (current->UhdmType() ==
                    UHDM_OBJECT_TYPE::uhdmmethod_func_call)
                  found = true;
                else if (current->UhdmType() ==
                         UHDM_OBJECT_TYPE::uhdmbit_select)
                  found = true;
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmstring_var: {
                if (current->UhdmType() ==
                    UHDM_OBJECT_TYPE::uhdmmethod_func_call)
                  found = true;
                else if (current->UhdmType() ==
                         UHDM_OBJECT_TYPE::uhdmbit_select)
                  found = true;
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmclass_typespec: {
                class_typespec* ctps = (class_typespec*)actual;
                any* tmp = bindClassTypespec(ctps, current, name, found);
                if (found) {
                  previous = tmp;
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmio_decl: {
                io_decl* decl = (io_decl*)actual;
                typespec* tps = nullptr;
                if (ref_typespec* rt = decl->Typespec()) {
                  tps = rt->Actual_typespec();
                }
                if (tps == nullptr) break;
                UHDM_OBJECT_TYPE ttype = tps->UhdmType();
                if (ttype == UHDM_OBJECT_TYPE::uhdmstring_typespec) {
                  found = true;
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmclass_typespec) {
                  class_typespec* ctps = (class_typespec*)tps;
                  any* tmp = bindClassTypespec(ctps, current, name, found);
                  if (found) {
                    previous = tmp;
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmstruct_typespec) {
                  struct_typespec* stpt = (struct_typespec*)tps;
                  for (typespec_member* member : *stpt->Members()) {
                    if (member->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(member);
                      }
                      previous = member;
                      found = true;
                      break;
                    }
                  }
                  if (name == "name") {
                    // Builtin introspection
                    found = true;
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmenum_typespec) {
                  if (name == "name") {
                    // Builtin introspection
                    found = true;
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmunion_typespec) {
                  union_typespec* stpt = (union_typespec*)tps;
                  for (typespec_member* member : *stpt->Members()) {
                    if (member->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(member);
                      }
                      previous = member;
                      found = true;
                      break;
                    }
                  }
                  if (name == "name") {
                    // Builtin introspection
                    found = true;
                  }
                }
                if (decl->Ranges()) {
                  if (current->UhdmType() ==
                      UHDM_OBJECT_TYPE::uhdmmethod_func_call)
                    found = true;
                  else if (current->UhdmType() ==
                           UHDM_OBJECT_TYPE::uhdmbit_select)
                    found = true;
                }
                // TODO: class method support
                if (current->UhdmType() ==
                    UHDM_OBJECT_TYPE::uhdmmethod_func_call)
                  found = true;
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmparameter: {
                parameter* param = (parameter*)actual;
                const typespec* tps = nullptr;
                if (const ref_typespec* rt = param->Typespec()) {
                  tps = rt->Actual_typespec();
                }
                if (tps == nullptr) break;
                UHDM_OBJECT_TYPE ttype = tps->UhdmType();
                if (ttype == UHDM_OBJECT_TYPE::uhdmpacked_array_typespec) {
                  packed_array_typespec* ptps = (packed_array_typespec*)tps;
                  if (const ref_typespec* ert = ptps->Elem_typespec()) {
                    if (const typespec* ets = ert->Actual_typespec()) {
                      tps = ets;
                      ttype = ets->UhdmType();
                    }
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmarray_typespec) {
                  array_typespec* ptps = (array_typespec*)tps;
                  if (const ref_typespec* ert = ptps->Elem_typespec()) {
                    if (const typespec* ets = ert->Actual_typespec()) {
                      tps = ets;
                      ttype = ets->UhdmType();
                    }
                  }
                }
                if (ttype == UHDM_OBJECT_TYPE::uhdmstring_typespec) {
                  found = true;
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmclass_typespec) {
                  class_typespec* ctps = (class_typespec*)tps;
                  any* tmp = bindClassTypespec(ctps, current, name, found);
                  if (found) {
                    previous = tmp;
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmstruct_typespec) {
                  struct_typespec* stpt = (struct_typespec*)tps;
                  for (typespec_member* member : *stpt->Members()) {
                    if (member->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(member);
                      }
                      previous = member;
                      found = true;
                      break;
                    }
                  }
                  if (name == "name") {
                    // Builtin introspection
                    found = true;
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmenum_typespec) {
                  if (name == "name") {
                    // Builtin introspection
                    found = true;
                  }
                } else if (ttype == UHDM_OBJECT_TYPE::uhdmunion_typespec) {
                  union_typespec* stpt = (union_typespec*)tps;
                  for (typespec_member* member : *stpt->Members()) {
                    if (member->VpiName() == name) {
                      if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                        cro->Actual_group(member);
                      }
                      previous = member;
                      found = true;
                      break;
                    }
                  }
                  if (name == "name") {
                    // Builtin introspection
                    found = true;
                  }
                }
                if (param->Ranges()) {
                  if (current->UhdmType() ==
                      UHDM_OBJECT_TYPE::uhdmmethod_func_call)
                    found = true;
                  else if (current->UhdmType() ==
                           UHDM_OBJECT_TYPE::uhdmbit_select)
                    found = true;
                }
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmoperation: {
                operation* op = (operation*)actual;
                if (op->VpiOpType() != vpiAssignmentPatternOp) {
                  break;
                }
                const struct_typespec* stps = nullptr;
                if (const ref_typespec* rt = op->Typespec()) {
                  stps = rt->Actual_typespec<struct_typespec>();
                }
                if (stps == nullptr) break;
                std::vector<std::string_view> fieldNames;
                std::vector<const typespec*> fieldTypes;
                for (typespec_member* memb : *stps->Members()) {
                  if (const ref_typespec* rt = memb->Typespec()) {
                    fieldNames.emplace_back(memb->VpiName());
                    fieldTypes.emplace_back(rt->Actual_typespec());
                  }
                }
                std::vector<any*> tmp(fieldNames.size());
                VectorOfany* orig = op->Operands();
                any* defaultOp = nullptr;
                any* res = nullptr;
                int32_t index = 0;
                for (auto oper : *orig) {
                  if (oper->UhdmType() ==
                      UHDM_OBJECT_TYPE::uhdmtagged_pattern) {
                    tagged_pattern* tp = (tagged_pattern*)oper;
                    const typespec* ttp = nullptr;
                    if (const ref_typespec* rt = tp->Typespec()) {
                      ttp = rt->Actual_typespec();
                    }
                    const std::string_view tname = ttp->VpiName();
                    bool oper_found = false;
                    if (tname == "default") {
                      defaultOp = oper;
                      oper_found = true;
                    }
                    for (uint32_t i = 0; i < fieldNames.size(); i++) {
                      if (tname == fieldNames[i]) {
                        tmp[i] = oper;
                        oper_found = true;
                        res = tmp[i];
                        break;
                      }
                    }
                    if (oper_found == false) {
                      for (uint32_t i = 0; i < fieldTypes.size(); i++) {
                        if (ttp->UhdmType() == fieldTypes[i]->UhdmType()) {
                          tmp[i] = oper;
                          oper_found = true;
                          res = tmp[i];
                          break;
                        }
                      }
                    }
                  } else {
                    if (index < (int32_t)tmp.size()) {
                      tmp[index] = oper;
                      found = true;
                      res = tmp[index];
                    }
                  }
                  index++;
                }
                if (res == nullptr) {
                  if (defaultOp) {
                    res = defaultOp;
                  }
                }
                previous = res;
                break;
              }
              case UHDM_OBJECT_TYPE::uhdmref_var: {
                found = true;
                // TODO: class var support
                break;
              }
              default:
                // TODO: class method support
                if (current->UhdmType() ==
                    UHDM_OBJECT_TYPE::uhdmmethod_func_call)
                  found = true;
                break;
            }
            if (!found) {
              if ((!elaboratorContext->m_elaborator.muteErrors()) &&
                  (!elaboratorContext->m_elaborator.isInUhdmAllIterator())) {
                const std::string errMsg(VpiName());
                context->m_serializer->GetErrorHandler()(
                    ErrorType::UHDM_UNRESOLVED_HIER_PATH, errMsg, this,
                    nullptr);
              }
            }
          } else {
            if ((!elaboratorContext->m_elaborator.muteErrors()) &&
                (!elaboratorContext->m_elaborator.isInUhdmAllIterator())) {
              if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmbit_select) {
                break;
              }
              const std::string errMsg(VpiName());
              context->m_serializer->GetErrorHandler()(
                  ErrorType::UHDM_UNRESOLVED_HIER_PATH, errMsg, this, nullptr);
            }
          }
        } else if (previous->UhdmType() ==
                   UHDM_OBJECT_TYPE::uhdmtypespec_member) {
          typespec_member* member = (typespec_member*)previous;
          const typespec* tps = nullptr;
          if (const ref_typespec* rt = member->Typespec()) {
            tps = rt->Actual_typespec();
          }
          if (tps == nullptr) break;
          UHDM_OBJECT_TYPE ttype = tps->UhdmType();
          if (ttype == UHDM_OBJECT_TYPE::uhdmpacked_array_typespec) {
            packed_array_typespec* ptps = (packed_array_typespec*)tps;
            if (const ref_typespec* rt = ptps->Elem_typespec()) {
              tps = rt->Actual_typespec();
              ttype = tps->UhdmType();
            }
          } else if (ttype == UHDM_OBJECT_TYPE::uhdmarray_typespec) {
            array_typespec* ptps = (array_typespec*)tps;
            if (const ref_typespec* rt = ptps->Elem_typespec()) {
              tps = rt->Actual_typespec();
              ttype = tps->UhdmType();
            }
          }
          if (ttype == UHDM_OBJECT_TYPE::uhdmstruct_typespec) {
            struct_typespec* stpt = (struct_typespec*)tps;
            for (typespec_member* tsmember : *stpt->Members()) {
              if (tsmember->VpiName() == name) {
                if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                  cro->Actual_group(tsmember);
                  previous = tsmember;
                  found = true;
                  break;
                }
              }
            }
          } else if (ttype == UHDM_OBJECT_TYPE::uhdmunion_typespec) {
            union_typespec* stpt = (union_typespec*)tps;
            for (typespec_member* tsmember : *stpt->Members()) {
              if (tsmember->VpiName() == name) {
                if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                  cro->Actual_group(tsmember);
                  previous = tsmember;
                  found = true;
                  break;
                }
              }
            }
          } else if (ttype == UHDM_OBJECT_TYPE::uhdmstring_typespec) {
            if (name == "len") {
              found = true;
            }
          }
        } else if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmarray_var) {
          array_var* avar = (array_var*)previous;
          if (VectorOfvariables* vars = avar->Variables()) {
            if (!vars->empty()) {
              variables* actual = vars->front();
              UHDM_OBJECT_TYPE actual_type = actual->UhdmType();
              switch (actual_type) {
                case UHDM_OBJECT_TYPE::uhdmstruct_net:
                case UHDM_OBJECT_TYPE::uhdmstruct_var: {
                  VectorOftypespec_member* members = nullptr;
                  if (actual->UhdmType() == UHDM_OBJECT_TYPE::uhdmstruct_net) {
                    if (ref_typespec* rt = ((struct_net*)actual)->Typespec()) {
                      if (struct_typespec* sts =
                              rt->Actual_typespec<struct_typespec>()) {
                        members = sts->Members();
                      } else if (union_typespec* uts =
                                     rt->Actual_typespec<union_typespec>()) {
                        members = uts->Members();
                      }
                    }
                  } else if (actual->UhdmType() ==
                             UHDM_OBJECT_TYPE::uhdmstruct_var) {
                    if (ref_typespec* rt = ((struct_var*)actual)->Typespec()) {
                      if (struct_typespec* sts =
                              rt->Actual_typespec<struct_typespec>()) {
                        members = sts->Members();
                      }
                    }
                  }
                  if (members) {
                    for (typespec_member* member : *members) {
                      if (member->VpiName() == name) {
                        if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                          cro->Actual_group(member);
                        }
                        previous = member;
                        found = true;
                        break;
                      }
                    }
                  }
                  break;
                }
                default:
                  break;
              }
            }
          }
        } else if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmstruct_var ||
                   previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmstruct_net) {
          VectorOftypespec_member* members = nullptr;
          if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmstruct_net) {
            if (ref_typespec* rt = ((struct_net*)previous)->Typespec()) {
              if (struct_typespec* sts =
                      rt->Actual_typespec<struct_typespec>()) {
                members = sts->Members();
              } else if (union_typespec* uts =
                             rt->Actual_typespec<union_typespec>()) {
                members = uts->Members();
              }
            }
          } else if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmstruct_var) {
            if (ref_typespec* rt = ((struct_var*)previous)->Typespec()) {
              if (struct_typespec* sts =
                      rt->Actual_typespec<struct_typespec>()) {
                members = sts->Members();
              }
            }
          }
          if (members) {
            for (typespec_member* member : *members) {
              if (member->VpiName() == name) {
                if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                  cro->Actual_group(member);
                }
                previous = member;
                found = true;
                break;
              }
            }
          }
        } else if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmmodule_inst) {
          module_inst* mod = (module_inst*)previous;
          if (mod->Variables()) {
            for (variables* var : *mod->Variables()) {
              if (var->VpiName() == name) {
                if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                  cro->Actual_group(var);
                }
                previous = var;
                found = true;
                break;
              }
            }
          }

          if (!found && mod->Nets()) {
            for (nets* n : *mod->Nets()) {
              if (n->VpiName() == name) {
                if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                  cro->Actual_group(n);
                }
                previous = n;
                found = true;
                break;
              }
            }
          }
          if (!found && mod->Modules()) {
            for (auto m : *mod->Modules()) {
              if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                found = true;
                previous = m;
                break;
              }
            }
          }
          break;
        } else if (previous->UhdmType() == UHDM_OBJECT_TYPE::uhdmgen_scope) {
          gen_scope* scope = (gen_scope*)previous;
          if (obj->UhdmType() == UHDM_OBJECT_TYPE::uhdmmethod_func_call) {
            method_func_call* call = (method_func_call*)current;
            if (scope->Task_funcs()) {
              for (auto tf : *scope->Task_funcs()) {
                if (tf->VpiName() == name) {
                  call->Function(any_cast<function*>(tf));
                  previous = (any*)call->Function();
                  found = true;
                  break;
                }
              }
            }
          } else if (obj->UhdmType() ==
                     UHDM_OBJECT_TYPE::uhdmmethod_task_call) {
            method_task_call* call = (method_task_call*)current;
            if (scope->Task_funcs()) {
              for (auto tf : *scope->Task_funcs()) {
                if (tf->VpiName() == name) {
                  call->Task(any_cast<task*>(tf));
                  found = true;
                  previous = (any*)call->Task();
                  break;
                }
              }
            }
          } else {
            if (scope->Modules()) {
              for (auto m : *scope->Modules()) {
                if (m->VpiName() == name || m->VpiName() == nameIndexed) {
                  found = true;
                  previous = m;
                  if (ref_obj* cro = any_cast<ref_obj*>(current)) {
                    cro->Actual_group(m);
                  }
                  break;
                }
              }
            }
          }
        }
      }
      if (!found) previous = current;
    }
  }
  if (auto vec = VpiUses()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiUses(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  return clone;
}
}  // namespace UHDM
