/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   concurrent_assertions.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/concurrent_assertions.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/expr.h>
#include <uhdm/property_inst_spec_group.h>
#include <uhdm/stmt.h>


namespace UHDM {
std::string_view concurrent_assertions::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool concurrent_assertions::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view concurrent_assertions::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<concurrent_assertions*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool concurrent_assertions::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* concurrent_assertions::GetByVpiName(std::string_view name) const {
  if ((clocking_event_ != nullptr) && (clocking_event_->VpiName().compare(name) == 0)) {
    return clocking_event_;
  }
  if ((stmt_ != nullptr) && (stmt_->VpiName().compare(name) == 0)) {
    return stmt_;
  }
  if ((vpiProperty_ != nullptr) && (vpiProperty_->VpiName().compare(name) == 0)) {
    return vpiProperty_;
  }
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> concurrent_assertions::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiClockingEvent: return std::make_tuple(clocking_event_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiProperty: return std::make_tuple(vpiProperty_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

concurrent_assertions::vpi_property_value_t concurrent_assertions::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiIsClockInferred: return vpi_property_value_t(VpiIsClockInferred());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void concurrent_assertions::DeepCopy(concurrent_assertions* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Clocking_event()) clone->Clocking_event(obj->DeepClone(clone, context));
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  if (auto obj = VpiProperty()) clone->VpiProperty(obj->DeepClone(clone, context));
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t concurrent_assertions::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiIsClockInferred() == rhs->VpiIsClockInferred()) ? 0 : (lhs->VpiIsClockInferred() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Clocking_event(), rhs->Clocking_event(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Stmt(), rhs->Stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiProperty(), rhs->VpiProperty(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
