/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   constr_foreach.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/constr_foreach.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/constraint_expr.h>
#include <uhdm/variables.h>
#include <uhdm/variables_operation_group.h>


namespace UHDM {
const BaseClass* constr_foreach::GetByVpiName(std::string_view name) const {
  if ((variable_ != nullptr) && (variable_->VpiName().compare(name) == 0)) {
    return variable_;
  }
  if (vpiLoopVars_ != nullptr) {
    for (const BaseClass *ref : *vpiLoopVars_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (constraint_exprs_ != nullptr) {
    for (const BaseClass *ref : *constraint_exprs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> constr_foreach::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiConstraintExpr: return std::make_tuple(nullptr, uhdmconstraint_exprs, (const std::vector<const BaseClass*>*)constraint_exprs_);
    case vpiLoopVars: return std::make_tuple(nullptr, uhdmvpiLoopVars, (const std::vector<const BaseClass*>*)vpiLoopVars_);
    case vpiVariables: return std::make_tuple(variable_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

constr_foreach::vpi_property_value_t constr_foreach::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void constr_foreach::DeepCopy(constr_foreach* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterConstr_foreach(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Variable()) clone->Variable(obj->DeepClone(clone, context));
  if (auto vec = VpiLoopVars()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiLoopVars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Constraint_exprs()) {
    auto clone_vec = context->m_serializer->MakeConstraint_exprVec();
    clone->Constraint_exprs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveConstr_foreach(clone, nullptr);
}

constr_foreach* constr_foreach::DeepClone(BaseClass* parent, CloneContext* context) const {
  constr_foreach* const clone = context->m_serializer->MakeConstr_foreach();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t constr_foreach::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Variable(), rhs->Variable(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->VpiLoopVars(), rhs, rhs->VpiLoopVars(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Constraint_exprs(), rhs, rhs->Constraint_exprs(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
