/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   constr_if_else.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/constr_if_else.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/constraint_expr.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* constr_if_else::GetByVpiName(std::string_view name) const {
  if ((condition_ != nullptr) && (condition_->VpiName().compare(name) == 0)) {
    return condition_;
  }
  if (constraint_exprs_ != nullptr) {
    for (const BaseClass *ref : *constraint_exprs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (else_constraint_exprs_ != nullptr) {
    for (const BaseClass *ref : *else_constraint_exprs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> constr_if_else::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCondition: return std::make_tuple(condition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiConstraintExpr: return std::make_tuple(nullptr, uhdmconstraint_exprs, (const std::vector<const BaseClass*>*)constraint_exprs_);
    case vpiElseConst: return std::make_tuple(nullptr, uhdmelse_constraint_exprs, (const std::vector<const BaseClass*>*)else_constraint_exprs_);
  }
  return basetype_t::GetByVpiType(type);
}

constr_if_else::vpi_property_value_t constr_if_else::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void constr_if_else::DeepCopy(constr_if_else* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterConstr_if_else(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Condition()) clone->Condition(obj->DeepClone(clone, context));
  if (auto vec = Constraint_exprs()) {
    auto clone_vec = context->m_serializer->MakeConstraint_exprVec();
    clone->Constraint_exprs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Else_constraint_exprs()) {
    auto clone_vec = context->m_serializer->MakeConstraint_exprVec();
    clone->Else_constraint_exprs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveConstr_if_else(clone, nullptr);
}

constr_if_else* constr_if_else::DeepClone(BaseClass* parent, CloneContext* context) const {
  constr_if_else* const clone = context->m_serializer->MakeConstr_if_else();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t constr_if_else::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Condition(), rhs->Condition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Constraint_exprs(), rhs, rhs->Constraint_exprs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Else_constraint_exprs(), rhs, rhs->Else_constraint_exprs(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
