/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   constraint_ordering.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/constraint_ordering.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* constraint_ordering::GetByVpiName(std::string_view name) const {
  if (solve_befores_ != nullptr) {
    for (const BaseClass *ref : *solve_befores_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (solve_afters_ != nullptr) {
    for (const BaseClass *ref : *solve_afters_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> constraint_ordering::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiSolveAfter: return std::make_tuple(nullptr, uhdmsolve_afters, (const std::vector<const BaseClass*>*)solve_afters_);
    case vpiSolveBefore: return std::make_tuple(nullptr, uhdmsolve_befores, (const std::vector<const BaseClass*>*)solve_befores_);
  }
  return basetype_t::GetByVpiType(type);
}

constraint_ordering::vpi_property_value_t constraint_ordering::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void constraint_ordering::DeepCopy(constraint_ordering* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterConstraint_ordering(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Solve_befores()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Solve_befores(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Solve_afters()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Solve_afters(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveConstraint_ordering(clone, nullptr);
}

constraint_ordering* constraint_ordering::DeepClone(BaseClass* parent, CloneContext* context) const {
  constraint_ordering* const clone = context->m_serializer->MakeConstraint_ordering();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t constraint_ordering::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->Solve_befores(), rhs, rhs->Solve_befores(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Solve_afters(), rhs, rhs->Solve_afters(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
