/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   cont_assign.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/cont_assign.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/cont_assign_bit.h>
#include <uhdm/expr.h>


namespace UHDM {
std::string_view cont_assign::VpiValue() const {
  return vpiValue_ ? serializer_->GetSymbol(vpiValue_) : kEmpty;
}

bool cont_assign::VpiValue(std::string_view data) {
  vpiValue_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* cont_assign::GetByVpiName(std::string_view name) const {
  if ((delay_ != nullptr) && (delay_->VpiName().compare(name) == 0)) {
    return delay_;
  }
  if ((rhs_ != nullptr) && (rhs_->VpiName().compare(name) == 0)) {
    return rhs_;
  }
  if ((lhs_ != nullptr) && (lhs_->VpiName().compare(name) == 0)) {
    return lhs_;
  }
  if (cont_assign_bits_ != nullptr) {
    for (const BaseClass *ref : *cont_assign_bits_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> cont_assign::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiBit: return std::make_tuple(nullptr, uhdmcont_assign_bits, (const std::vector<const BaseClass*>*)cont_assign_bits_);
    case vpiDelay: return std::make_tuple(delay_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLhs: return std::make_tuple(lhs_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRhs: return std::make_tuple(rhs_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

cont_assign::vpi_property_value_t cont_assign::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiNetDeclAssign: return vpi_property_value_t(VpiNetDeclAssign());
    case vpiStrength0: return vpi_property_value_t(VpiStrength0());
    case vpiStrength1: return vpi_property_value_t(VpiStrength1());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void cont_assign::DeepCopy(cont_assign* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterCont_assign(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Delay()) clone->Delay(obj->DeepClone(clone, context));
  if (auto obj = Rhs()) clone->Rhs(obj->DeepClone(clone, context));
  if (auto obj = Lhs()) clone->Lhs(obj->DeepClone(clone, context));
  if (auto vec = Cont_assign_bits()) {
    auto clone_vec = context->m_serializer->MakeCont_assign_bitVec();
    clone->Cont_assign_bits(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveCont_assign(clone, nullptr);
}

int32_t cont_assign::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiNetDeclAssign() == rhs->VpiNetDeclAssign()) ? 0 : (lhs->VpiNetDeclAssign() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiStrength0() - rhs->VpiStrength0()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiStrength1() - rhs->VpiStrength1()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Delay(), rhs->Delay(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Rhs(), rhs->Rhs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Lhs(), rhs->Lhs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Cont_assign_bits(), rhs, rhs->Cont_assign_bits(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
