/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   delay_control.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/delay_control.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/stmt.h>


namespace UHDM {
std::string_view delay_control::VpiDelay() const {
  return vpiDelay_ ? serializer_->GetSymbol(vpiDelay_) : kEmpty;
}

bool delay_control::VpiDelay(std::string_view data) {
  vpiDelay_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* delay_control::GetByVpiName(std::string_view name) const {
  if ((stmt_ != nullptr) && (stmt_->VpiName().compare(name) == 0)) {
    return stmt_;
  }
  if ((delay_ != nullptr) && (delay_->VpiName().compare(name) == 0)) {
    return delay_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> delay_control::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiDelay: return std::make_tuple(delay_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

delay_control::vpi_property_value_t delay_control::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void delay_control::DeepCopy(delay_control* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterDelay_control(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  if (auto obj = Delay()) clone->Delay(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveDelay_control(clone, nullptr);
}

delay_control* delay_control::DeepClone(BaseClass* parent, CloneContext* context) const {
  delay_control* const clone = context->m_serializer->MakeDelay_control();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t delay_control::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Stmt(), rhs->Stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Delay(), rhs->Delay(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
