/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   design.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/design.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/class_defn.h>
#include <uhdm/include_file_info.h>
#include <uhdm/interface_inst.h>
#include <uhdm/let_decl.h>
#include <uhdm/module_inst.h>
#include <uhdm/package.h>
#include <uhdm/param_assign.h>
#include <uhdm/parameters.h>
#include <uhdm/program.h>
#include <uhdm/task_func.h>
#include <uhdm/typespec.h>
#include <uhdm/udp_defn.h>


namespace UHDM {
std::string_view design::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool design::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* design::GetByVpiName(std::string_view name) const {
  if (include_file_infos_ != nullptr) {
    for (const BaseClass *ref : *include_file_infos_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (allPackages_ != nullptr) {
    for (const BaseClass *ref : *allPackages_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (topPackages_ != nullptr) {
    for (const BaseClass *ref : *topPackages_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (allClasses_ != nullptr) {
    for (const BaseClass *ref : *allClasses_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (allInterfaces_ != nullptr) {
    for (const BaseClass *ref : *allInterfaces_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (allUdps_ != nullptr) {
    for (const BaseClass *ref : *allUdps_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (allPrograms_ != nullptr) {
    for (const BaseClass *ref : *allPrograms_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (allModules_ != nullptr) {
    for (const BaseClass *ref : *allModules_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (typespecs_ != nullptr) {
    for (const BaseClass *ref : *typespecs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (let_decls_ != nullptr) {
    for (const BaseClass *ref : *let_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (task_funcs_ != nullptr) {
    for (const BaseClass *ref : *task_funcs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (parameters_ != nullptr) {
    for (const BaseClass *ref : *parameters_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (param_assigns_ != nullptr) {
    for (const BaseClass *ref : *param_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (topModules_ != nullptr) {
    for (const BaseClass *ref : *topModules_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> design::GetByVpiType(int32_t type) const {
  switch (type) {
    case uhdmallClasses: return std::make_tuple(nullptr, uhdmallClasses, (const std::vector<const BaseClass*>*)allClasses_);
    case uhdmallInterfaces: return std::make_tuple(nullptr, uhdmallInterfaces, (const std::vector<const BaseClass*>*)allInterfaces_);
    case uhdmallModules: return std::make_tuple(nullptr, uhdmallModules, (const std::vector<const BaseClass*>*)allModules_);
    case uhdmallPackages: return std::make_tuple(nullptr, uhdmallPackages, (const std::vector<const BaseClass*>*)allPackages_);
    case uhdmallPrograms: return std::make_tuple(nullptr, uhdmallPrograms, (const std::vector<const BaseClass*>*)allPrograms_);
    case uhdmallUdps: return std::make_tuple(nullptr, uhdmallUdps, (const std::vector<const BaseClass*>*)allUdps_);
    case uhdmtopModules: return std::make_tuple(nullptr, uhdmtopModules, (const std::vector<const BaseClass*>*)topModules_);
    case uhdmtopPackages: return std::make_tuple(nullptr, uhdmtopPackages, (const std::vector<const BaseClass*>*)topPackages_);
    case vpiIncludeFileInfo: return std::make_tuple(nullptr, uhdminclude_file_infos, (const std::vector<const BaseClass*>*)include_file_infos_);
    case vpiLetDecl: return std::make_tuple(nullptr, uhdmlet_decls, (const std::vector<const BaseClass*>*)let_decls_);
    case vpiParamAssign: return std::make_tuple(nullptr, uhdmparam_assigns, (const std::vector<const BaseClass*>*)param_assigns_);
    case vpiParameter: return std::make_tuple(nullptr, uhdmparameters, (const std::vector<const BaseClass*>*)parameters_);
    case vpiTaskFunc: return std::make_tuple(nullptr, uhdmtask_funcs, (const std::vector<const BaseClass*>*)task_funcs_);
    case vpiTypedef: return std::make_tuple(nullptr, uhdmtypespecs, (const std::vector<const BaseClass*>*)typespecs_);
  }
  return basetype_t::GetByVpiType(type);
}

design::vpi_property_value_t design::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiElaborated: return vpi_property_value_t(VpiElaborated());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void design::DeepCopy(design* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterDesign(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Include_file_infos()) {
    auto clone_vec = context->m_serializer->MakeInclude_file_infoVec();
    clone->Include_file_infos(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = AllPackages()) {
    auto clone_vec = context->m_serializer->MakePackageVec();
    clone->AllPackages(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = TopPackages()) {
    auto clone_vec = context->m_serializer->MakePackageVec();
    clone->TopPackages(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = AllClasses()) {
    auto clone_vec = context->m_serializer->MakeClass_defnVec();
    clone->AllClasses(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = AllInterfaces()) {
    auto clone_vec = context->m_serializer->MakeInterface_instVec();
    clone->AllInterfaces(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = AllUdps()) {
    auto clone_vec = context->m_serializer->MakeUdp_defnVec();
    clone->AllUdps(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = AllPrograms()) {
    auto clone_vec = context->m_serializer->MakeProgramVec();
    clone->AllPrograms(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = AllModules()) {
    auto clone_vec = context->m_serializer->MakeModule_instVec();
    clone->AllModules(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Typespecs()) {
    auto clone_vec = context->m_serializer->MakeTypespecVec();
    clone->Typespecs(clone_vec);
    clone_vec->insert(clone_vec->cend(), vec->cbegin(), vec->cend());
  }
  if (auto vec = Let_decls()) {
    auto clone_vec = context->m_serializer->MakeLet_declVec();
    clone->Let_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Task_funcs()) {
    auto clone_vec = context->m_serializer->MakeTask_funcVec();
    clone->Task_funcs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Parameters()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Parameters(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Param_assigns()) {
    auto clone_vec = context->m_serializer->MakeParam_assignVec();
    clone->Param_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = TopModules()) {
    auto clone_vec = context->m_serializer->MakeModule_instVec();
    clone->TopModules(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveDesign(clone, nullptr);
}

design* design::DeepClone(BaseClass* parent, CloneContext* context) const {
  design* const clone = context->m_serializer->MakeDesign();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t design::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiElaborated() == rhs->VpiElaborated()) ? 0 : (lhs->VpiElaborated() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Include_file_infos(), rhs, rhs->Include_file_infos(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->AllPackages(), rhs, rhs->AllPackages(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->TopPackages(), rhs, rhs->TopPackages(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->AllClasses(), rhs, rhs->AllClasses(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->AllInterfaces(), rhs, rhs->AllInterfaces(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->AllUdps(), rhs, rhs->AllUdps(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->AllPrograms(), rhs, rhs->AllPrograms(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->AllModules(), rhs, rhs->AllModules(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Typespecs(), rhs, rhs->Typespecs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Let_decls(), rhs, rhs->Let_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Task_funcs(), rhs, rhs->Task_funcs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Parameters(), rhs, rhs->Parameters(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Param_assigns(), rhs, rhs->Param_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->TopModules(), rhs, rhs->TopModules(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
