/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   disable.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/disable.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/task_func_named_begin_fork_group.h>


namespace UHDM {
const BaseClass* disable::GetByVpiName(std::string_view name) const {
  if ((vpiExpr_ != nullptr) && (vpiExpr_->VpiName().compare(name) == 0)) {
    return vpiExpr_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> disable::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(vpiExpr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

disable::vpi_property_value_t disable::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void disable::DeepCopy(disable* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterDisable(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiExpr()) clone->VpiExpr((expr*) obj);
  elaboratorContext->m_elaborator.leaveDisable(clone, nullptr);
}

disable* disable::DeepClone(BaseClass* parent, CloneContext* context) const {
  disable* const clone = context->m_serializer->MakeDisable();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t disable::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->VpiExpr(), rhs->VpiExpr(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
