/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   dist_item.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/dist_item.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/expr_range_group.h>


namespace UHDM {
const BaseClass* dist_item::GetByVpiName(std::string_view name) const {
  if ((value_range_ != nullptr) && (value_range_->VpiName().compare(name) == 0)) {
    return value_range_;
  }
  if ((weight_ != nullptr) && (weight_->VpiName().compare(name) == 0)) {
    return weight_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> dist_item::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiValueRange: return std::make_tuple(value_range_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiWeight: return std::make_tuple(weight_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

dist_item::vpi_property_value_t dist_item::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDistType: return vpi_property_value_t(VpiDistType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void dist_item::DeepCopy(dist_item* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterDist_item(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Value_range()) clone->Value_range(obj->DeepClone(clone, context));
  if (auto obj = Weight()) clone->Weight(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveDist_item(clone, nullptr);
}

dist_item* dist_item::DeepClone(BaseClass* parent, CloneContext* context) const {
  dist_item* const clone = context->m_serializer->MakeDist_item();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t dist_item::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiDistType() - rhs->VpiDistType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Value_range(), rhs->Value_range(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Weight(), rhs->Weight(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
