/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   distribution.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/distribution.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/dist_item.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* distribution::GetByVpiName(std::string_view name) const {
  if (dist_items_ != nullptr) {
    for (const BaseClass *ref : *dist_items_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> distribution::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiDistItem: return std::make_tuple(nullptr, uhdmdist_items, (const std::vector<const BaseClass*>*)dist_items_);
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

distribution::vpi_property_value_t distribution::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiSoft: return vpi_property_value_t(VpiSoft());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void distribution::DeepCopy(distribution* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterDistribution(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Dist_items()) {
    auto clone_vec = context->m_serializer->MakeDist_itemVec();
    clone->Dist_items(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveDistribution(clone, nullptr);
}

distribution* distribution::DeepClone(BaseClass* parent, CloneContext* context) const {
  distribution* const clone = context->m_serializer->MakeDistribution();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t distribution::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiSoft() == rhs->VpiSoft()) ? 0 : (lhs->VpiSoft() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Dist_items(), rhs, rhs->Dist_items(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
