/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   enum_typespec.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/enum_typespec.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/enum_const.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
const BaseClass* enum_typespec::GetByVpiName(std::string_view name) const {
  if ((base_typespec_ != nullptr) && (base_typespec_->VpiName().compare(name) == 0)) {
    return base_typespec_;
  }
  if (enum_consts_ != nullptr) {
    for (const BaseClass *ref : *enum_consts_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> enum_typespec::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiBaseTypespec: return std::make_tuple(base_typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiEnumConst: return std::make_tuple(nullptr, uhdmenum_consts, (const std::vector<const BaseClass*>*)enum_consts_);
  }
  return basetype_t::GetByVpiType(type);
}

enum_typespec::vpi_property_value_t enum_typespec::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void enum_typespec::DeepCopy(enum_typespec* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterEnum_typespec(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Base_typespec()) clone->Base_typespec(obj->DeepClone(clone, context));
  if (auto vec = Enum_consts()) {
    auto clone_vec = context->m_serializer->MakeEnum_constVec();
    clone->Enum_consts(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveEnum_typespec(clone, nullptr);
}

enum_typespec* enum_typespec::DeepClone(BaseClass* parent, CloneContext* context) const {
  enum_typespec* const clone = context->m_serializer->MakeEnum_typespec();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t enum_typespec::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Base_typespec(), rhs->Base_typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Enum_consts(), rhs, rhs->Enum_consts(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
