/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   event_stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/event_stmt.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/named_event.h>


namespace UHDM {
const BaseClass* event_stmt::GetByVpiName(std::string_view name) const {
  if ((named_event_ != nullptr) && (named_event_->VpiName().compare(name) == 0)) {
    return named_event_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> event_stmt::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiNamedEvent: return std::make_tuple(named_event_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

event_stmt::vpi_property_value_t event_stmt::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiBlocking: return vpi_property_value_t(VpiBlocking());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void event_stmt::DeepCopy(event_stmt* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterEvent_stmt(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Named_event()) clone->Named_event(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveEvent_stmt(clone, nullptr);
}

event_stmt* event_stmt::DeepClone(BaseClass* parent, CloneContext* context) const {
  event_stmt* const clone = context->m_serializer->MakeEvent_stmt();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t event_stmt::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiBlocking() == rhs->VpiBlocking()) ? 0 : (lhs->VpiBlocking() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Named_event(), rhs->Named_event(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
