/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   expect_stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/expect_stmt.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/property_spec.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* expect_stmt::GetByVpiName(std::string_view name) const {
  if ((stmt_ != nullptr) && (stmt_->VpiName().compare(name) == 0)) {
    return stmt_;
  }
  if ((else_stmt_ != nullptr) && (else_stmt_->VpiName().compare(name) == 0)) {
    return else_stmt_;
  }
  if ((property_spec_ != nullptr) && (property_spec_->VpiName().compare(name) == 0)) {
    return property_spec_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> expect_stmt::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiElseStmt: return std::make_tuple(else_stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPropertySpec: return std::make_tuple(property_spec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

expect_stmt::vpi_property_value_t expect_stmt::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void expect_stmt::DeepCopy(expect_stmt* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterExpect_stmt(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  if (auto obj = Else_stmt()) clone->Else_stmt(obj->DeepClone(clone, context));
  if (auto obj = Property_spec()) clone->Property_spec(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveExpect_stmt(clone, nullptr);
}

expect_stmt* expect_stmt::DeepClone(BaseClass* parent, CloneContext* context) const {
  expect_stmt* const clone = context->m_serializer->MakeExpect_stmt();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t expect_stmt::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Stmt(), rhs->Stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Else_stmt(), rhs->Else_stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Property_spec(), rhs->Property_spec(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
