/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   expr.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/expr.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
std::string_view expr::VpiDecompile() const {
  return vpiDecompile_ ? serializer_->GetSymbol(vpiDecompile_) : kEmpty;
}

bool expr::VpiDecompile(std::string_view data) {
  vpiDecompile_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view expr::VpiValue() const {
  return vpiValue_ ? serializer_->GetSymbol(vpiValue_) : kEmpty;
}

bool expr::VpiValue(std::string_view data) {
  vpiValue_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* expr::GetByVpiName(std::string_view name) const {
  if ((typespec_ != nullptr) && (typespec_->VpiName().compare(name) == 0)) {
    return typespec_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> expr::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiTypespec: return std::make_tuple(typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

expr::vpi_property_value_t expr::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDecompile: {
      std::string_view data = VpiDecompile();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiSize: return vpi_property_value_t(VpiSize());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void expr::DeepCopy(expr* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
}

int32_t expr::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiDecompile().compare(rhs->VpiDecompile())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiSize() - rhs->VpiSize()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Typespec(), rhs->Typespec(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
