/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   expr_constr_group.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/expr_constr_group.h>

#include <iostream>
#include <uhdm/uhdm.h>

namespace UHDM {
bool expr_constr_groupGroupCompliant(const any* item) {
  if (item == nullptr) {
    return true;
  }
  UHDM_OBJECT_TYPE uhdmtype = item->UhdmType();
  if ((uhdmtype != uhdmarray_expr) &&
      (uhdmtype != uhdmarray_net) &&
      (uhdmtype != uhdmarray_var) &&
      (uhdmtype != uhdmbit_select) &&
      (uhdmtype != uhdmbit_var) &&
      (uhdmtype != uhdmbyte_var) &&
      (uhdmtype != uhdmchandle_var) &&
      (uhdmtype != uhdmclass_var) &&
      (uhdmtype != uhdmconstant) &&
      (uhdmtype != uhdmconstraint) &&
      (uhdmtype != uhdmenum_net) &&
      (uhdmtype != uhdmenum_var) &&
      (uhdmtype != uhdmexpr) &&
      (uhdmtype != uhdmfunc_call) &&
      (uhdmtype != uhdmhier_path) &&
      (uhdmtype != uhdmindexed_part_select) &&
      (uhdmtype != uhdmint_var) &&
      (uhdmtype != uhdminteger_net) &&
      (uhdmtype != uhdminteger_var) &&
      (uhdmtype != uhdmlet_expr) &&
      (uhdmtype != uhdmlogic_net) &&
      (uhdmtype != uhdmlogic_var) &&
      (uhdmtype != uhdmlong_int_var) &&
      (uhdmtype != uhdmmethod_func_call) &&
      (uhdmtype != uhdmmethod_task_call) &&
      (uhdmtype != uhdmnet) &&
      (uhdmtype != uhdmnet_bit) &&
      (uhdmtype != uhdmnets) &&
      (uhdmtype != uhdmoperation) &&
      (uhdmtype != uhdmpacked_array_net) &&
      (uhdmtype != uhdmpacked_array_var) &&
      (uhdmtype != uhdmparameter) &&
      (uhdmtype != uhdmpart_select) &&
      (uhdmtype != uhdmreal_var) &&
      (uhdmtype != uhdmref_obj) &&
      (uhdmtype != uhdmref_typespec) &&
      (uhdmtype != uhdmref_var) &&
      (uhdmtype != uhdmshort_int_var) &&
      (uhdmtype != uhdmshort_real_var) &&
      (uhdmtype != uhdmsimple_expr) &&
      (uhdmtype != uhdmspec_param) &&
      (uhdmtype != uhdmstring_var) &&
      (uhdmtype != uhdmstruct_net) &&
      (uhdmtype != uhdmstruct_var) &&
      (uhdmtype != uhdmsys_func_call) &&
      (uhdmtype != uhdmsys_task_call) &&
      (uhdmtype != uhdmtask_call) &&
      (uhdmtype != uhdmtf_call) &&
      (uhdmtype != uhdmtime_net) &&
      (uhdmtype != uhdmtime_var) &&
      (uhdmtype != uhdmunion_var) &&
      (uhdmtype != uhdmunsupported_expr) &&
      (uhdmtype != uhdmvar_bit) &&
      (uhdmtype != uhdmvar_select) &&
      (uhdmtype != uhdmvariables)) {
    item->GetSerializer()->GetErrorHandler()(ErrorType::UHDM_WRONG_OBJECT_TYPE, "Internal Error: adding wrong object type (" + UhdmName(uhdmtype) + ") in a expr_constr_group group!", item, nullptr);
    return false;
  }
  return true;
}

bool expr_constr_groupGroupCompliant(const VectorOfany* vec) {
  if (vec != nullptr) {
    for (auto item : *vec) {
      if (!expr_constr_groupGroupCompliant(item)) {
        return false;
      }
    }
  }
  return true;
}

}  // namespace UHDM
