/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   for_stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/for_stmt.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* for_stmt::GetByVpiName(std::string_view name) const {
  if (vpiForInitStmts_ != nullptr) {
    for (const BaseClass *ref : *vpiForInitStmts_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (vpiForIncStmts_ != nullptr) {
    for (const BaseClass *ref : *vpiForIncStmts_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((vpiForInitStmt_ != nullptr) && (vpiForInitStmt_->VpiName().compare(name) == 0)) {
    return vpiForInitStmt_;
  }
  if ((vpiCondition_ != nullptr) && (vpiCondition_->VpiName().compare(name) == 0)) {
    return vpiCondition_;
  }
  if ((vpiForIncStmt_ != nullptr) && (vpiForIncStmt_->VpiName().compare(name) == 0)) {
    return vpiForIncStmt_;
  }
  if ((vpiStmt_ != nullptr) && (vpiStmt_->VpiName().compare(name) == 0)) {
    return vpiStmt_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> for_stmt::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCondition: return std::make_tuple(vpiCondition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiForIncStmt: return std::make_tuple(vpiForIncStmt_, uhdmvpiForIncStmts, (const std::vector<const BaseClass*>*)vpiForIncStmts_);
    case vpiForInitStmt: return std::make_tuple(vpiForInitStmt_, uhdmvpiForInitStmts, (const std::vector<const BaseClass*>*)vpiForInitStmts_);
    case vpiStmt: return std::make_tuple(vpiStmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

for_stmt::vpi_property_value_t for_stmt::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiLocalVarDecls: return vpi_property_value_t(VpiLocalVarDecls());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void for_stmt::DeepCopy(for_stmt* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterFor_stmt(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = VpiForInitStmts()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiForInitStmts(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = VpiForIncStmts()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiForIncStmts(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = VpiForInitStmt()) clone->VpiForInitStmt(obj->DeepClone(clone, context));
  if (auto obj = VpiCondition()) clone->VpiCondition(obj->DeepClone(clone, context));
  if (auto obj = VpiForIncStmt()) clone->VpiForIncStmt(obj->DeepClone(clone, context));
  if (auto obj = VpiStmt()) clone->VpiStmt(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveFor_stmt(clone, nullptr);
}

for_stmt* for_stmt::DeepClone(BaseClass* parent, CloneContext* context) const {
  for_stmt* const clone = context->m_serializer->MakeFor_stmt();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t for_stmt::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiLocalVarDecls() - rhs->VpiLocalVarDecls()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->VpiForInitStmts(), rhs, rhs->VpiForInitStmts(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->VpiForIncStmts(), rhs, rhs->VpiForIncStmts(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiForInitStmt(), rhs->VpiForInitStmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiCondition(), rhs->VpiCondition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiForIncStmt(), rhs->VpiForIncStmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiStmt(), rhs->VpiStmt(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
