/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   fork_stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/fork_stmt.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* fork_stmt::GetByVpiName(std::string_view name) const {
  if (stmts_ != nullptr) {
    for (const BaseClass *ref : *stmts_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> fork_stmt::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiStmt: return std::make_tuple(nullptr, uhdmstmts, (const std::vector<const BaseClass*>*)stmts_);
  }
  return basetype_t::GetByVpiType(type);
}

fork_stmt::vpi_property_value_t fork_stmt::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiJoinType: return vpi_property_value_t(VpiJoinType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void fork_stmt::DeepCopy(fork_stmt* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterFork_stmt(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Stmts()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Stmts(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveFork_stmt(clone, nullptr);
}

fork_stmt* fork_stmt::DeepClone(BaseClass* parent, CloneContext* context) const {
  fork_stmt* const clone = context->m_serializer->MakeFork_stmt();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t fork_stmt::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiJoinType() - rhs->VpiJoinType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Stmts(), rhs, rhs->Stmts(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
