/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   gen_case.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/gen_case.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/case_item.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* gen_case::GetByVpiName(std::string_view name) const {
  if ((vpiCondition_ != nullptr) && (vpiCondition_->VpiName().compare(name) == 0)) {
    return vpiCondition_;
  }
  if (case_items_ != nullptr) {
    for (const BaseClass *ref : *case_items_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> gen_case::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCaseItem: return std::make_tuple(nullptr, uhdmcase_items, (const std::vector<const BaseClass*>*)case_items_);
    case vpiCondition: return std::make_tuple(vpiCondition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

gen_case::vpi_property_value_t gen_case::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void gen_case::DeepCopy(gen_case* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterGen_case(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiCondition()) clone->VpiCondition(obj->DeepClone(clone, context));
  if (auto vec = Case_items()) {
    auto clone_vec = context->m_serializer->MakeCase_itemVec();
    clone->Case_items(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveGen_case(clone, nullptr);
}

gen_case* gen_case::DeepClone(BaseClass* parent, CloneContext* context) const {
  gen_case* const clone = context->m_serializer->MakeGen_case();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t gen_case::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->VpiCondition(), rhs->VpiCondition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Case_items(), rhs, rhs->Case_items(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
