/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   gen_if.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/gen_if.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* gen_if::GetByVpiName(std::string_view name) const {
  if ((vpiCondition_ != nullptr) && (vpiCondition_->VpiName().compare(name) == 0)) {
    return vpiCondition_;
  }
  if ((vpiStmt_ != nullptr) && (vpiStmt_->VpiName().compare(name) == 0)) {
    return vpiStmt_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> gen_if::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCondition: return std::make_tuple(vpiCondition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(vpiStmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

gen_if::vpi_property_value_t gen_if::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void gen_if::DeepCopy(gen_if* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterGen_if(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiCondition()) clone->VpiCondition(obj->DeepClone(clone, context));
  if (auto obj = VpiStmt()) clone->VpiStmt(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveGen_if(clone, nullptr);
}

gen_if* gen_if::DeepClone(BaseClass* parent, CloneContext* context) const {
  gen_if* const clone = context->m_serializer->MakeGen_if();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t gen_if::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->VpiCondition(), rhs->VpiCondition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiStmt(), rhs->VpiStmt(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
