/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   gen_scope.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/gen_scope.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/alias_stmt.h>
#include <uhdm/array_net.h>
#include <uhdm/assertion.h>
#include <uhdm/clocking_block.h>
#include <uhdm/cont_assign.h>
#include <uhdm/def_param.h>
#include <uhdm/expr.h>
#include <uhdm/gen_scope_array.h>
#include <uhdm/interface_array.h>
#include <uhdm/interface_inst.h>
#include <uhdm/module_array.h>
#include <uhdm/module_inst.h>
#include <uhdm/net.h>
#include <uhdm/primitive.h>
#include <uhdm/primitive_array.h>
#include <uhdm/process_stmt.h>
#include <uhdm/program.h>
#include <uhdm/task_func.h>
#include <uhdm/tf_call.h>


namespace UHDM {
const BaseClass* gen_scope::GetByVpiName(std::string_view name) const {
  if ((vpiIndex_ != nullptr) && (vpiIndex_->VpiName().compare(name) == 0)) {
    return vpiIndex_;
  }
  if (nets_ != nullptr) {
    for (const BaseClass *ref : *nets_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (array_nets_ != nullptr) {
    for (const BaseClass *ref : *array_nets_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (process_ != nullptr) {
    for (const BaseClass *ref : *process_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (cont_assigns_ != nullptr) {
    for (const BaseClass *ref : *cont_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (modules_ != nullptr) {
    for (const BaseClass *ref : *modules_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (module_arrays_ != nullptr) {
    for (const BaseClass *ref : *module_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (primitives_ != nullptr) {
    for (const BaseClass *ref : *primitives_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (primitive_arrays_ != nullptr) {
    for (const BaseClass *ref : *primitive_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (def_params_ != nullptr) {
    for (const BaseClass *ref : *def_params_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (gen_scope_arrays_ != nullptr) {
    for (const BaseClass *ref : *gen_scope_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (programs_ != nullptr) {
    for (const BaseClass *ref : *programs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (program_arrays_ != nullptr) {
    for (const BaseClass *ref : *program_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (assertions_ != nullptr) {
    for (const BaseClass *ref : *assertions_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (interfaces_ != nullptr) {
    for (const BaseClass *ref : *interfaces_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (interface_arrays_ != nullptr) {
    for (const BaseClass *ref : *interface_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (alias_stmts_ != nullptr) {
    for (const BaseClass *ref : *alias_stmts_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (clocking_blocks_ != nullptr) {
    for (const BaseClass *ref : *clocking_blocks_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (task_funcs_ != nullptr) {
    for (const BaseClass *ref : *task_funcs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (elab_tasks_ != nullptr) {
    for (const BaseClass *ref : *elab_tasks_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> gen_scope::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAliasStmt: return std::make_tuple(nullptr, uhdmalias_stmts, (const std::vector<const BaseClass*>*)alias_stmts_);
    case vpiArrayNet: return std::make_tuple(nullptr, uhdmarray_nets, (const std::vector<const BaseClass*>*)array_nets_);
    case vpiAssertion: return std::make_tuple(nullptr, uhdmassertions, (const std::vector<const BaseClass*>*)assertions_);
    case vpiClockingBlock: return std::make_tuple(nullptr, uhdmclocking_blocks, (const std::vector<const BaseClass*>*)clocking_blocks_);
    case vpiContAssign: return std::make_tuple(nullptr, uhdmcont_assigns, (const std::vector<const BaseClass*>*)cont_assigns_);
    case vpiDefParam: return std::make_tuple(nullptr, uhdmdef_params, (const std::vector<const BaseClass*>*)def_params_);
    case vpiGenScopeArray: return std::make_tuple(nullptr, uhdmgen_scope_arrays, (const std::vector<const BaseClass*>*)gen_scope_arrays_);
    case vpiIndex: return std::make_tuple(vpiIndex_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInterface: return std::make_tuple(nullptr, uhdminterfaces, (const std::vector<const BaseClass*>*)interfaces_);
    case vpiInterfaceArray: return std::make_tuple(nullptr, uhdminterface_arrays, (const std::vector<const BaseClass*>*)interface_arrays_);
    case vpiModule: return std::make_tuple(nullptr, uhdmmodules, (const std::vector<const BaseClass*>*)modules_);
    case vpiModuleArray: return std::make_tuple(nullptr, uhdmmodule_arrays, (const std::vector<const BaseClass*>*)module_arrays_);
    case vpiNet: return std::make_tuple(nullptr, uhdmnets, (const std::vector<const BaseClass*>*)nets_);
    case vpiPrimitive: return std::make_tuple(nullptr, uhdmprimitives, (const std::vector<const BaseClass*>*)primitives_);
    case vpiPrimitiveArray: return std::make_tuple(nullptr, uhdmprimitive_arrays, (const std::vector<const BaseClass*>*)primitive_arrays_);
    case vpiProcess: return std::make_tuple(nullptr, uhdmprocess, (const std::vector<const BaseClass*>*)process_);
    case vpiProgram: return std::make_tuple(nullptr, uhdmprograms, (const std::vector<const BaseClass*>*)programs_);
    case vpiProgramArray: return std::make_tuple(nullptr, uhdmprogram_arrays, (const std::vector<const BaseClass*>*)program_arrays_);
    case vpiSysTaskCall: return std::make_tuple(nullptr, uhdmelab_tasks, (const std::vector<const BaseClass*>*)elab_tasks_);
    case vpiTaskFunc: return std::make_tuple(nullptr, uhdmtask_funcs, (const std::vector<const BaseClass*>*)task_funcs_);
  }
  return basetype_t::GetByVpiType(type);
}

gen_scope::vpi_property_value_t gen_scope::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiArrayMember: return vpi_property_value_t(VpiArrayMember());
    case vpiImplicitDecl: return vpi_property_value_t(VpiImplicitDecl());
    case vpiProtected: return vpi_property_value_t(VpiProtected());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void gen_scope::DeepCopy(gen_scope* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterGen_scope(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiIndex()) clone->VpiIndex(obj->DeepClone(clone, context));
  if (auto vec = Nets()) {
    auto clone_vec = context->m_serializer->MakeNetVec();
    clone->Nets(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_nets()) {
    auto clone_vec = context->m_serializer->MakeArray_netVec();
    clone->Array_nets(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Process()) {
    auto clone_vec = context->m_serializer->MakeProcess_stmtVec();
    clone->Process(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Cont_assigns()) {
    auto clone_vec = context->m_serializer->MakeCont_assignVec();
    clone->Cont_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Modules()) {
    auto clone_vec = context->m_serializer->MakeModule_instVec();
    clone->Modules(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Module_arrays()) {
    auto clone_vec = context->m_serializer->MakeModule_arrayVec();
    clone->Module_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Primitives()) {
    auto clone_vec = context->m_serializer->MakePrimitiveVec();
    clone->Primitives(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Primitive_arrays()) {
    auto clone_vec = context->m_serializer->MakePrimitive_arrayVec();
    clone->Primitive_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Def_params()) {
    auto clone_vec = context->m_serializer->MakeDef_paramVec();
    clone->Def_params(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Gen_scope_arrays()) {
    auto clone_vec = context->m_serializer->MakeGen_scope_arrayVec();
    clone->Gen_scope_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Programs()) {
    auto clone_vec = context->m_serializer->MakeProgramVec();
    clone->Programs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Program_arrays()) {
    auto clone_vec = context->m_serializer->MakeProgramVec();
    clone->Program_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Assertions()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Assertions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Interfaces()) {
    auto clone_vec = context->m_serializer->MakeInterface_instVec();
    clone->Interfaces(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Interface_arrays()) {
    auto clone_vec = context->m_serializer->MakeInterface_arrayVec();
    clone->Interface_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Alias_stmts()) {
    auto clone_vec = context->m_serializer->MakeAlias_stmtVec();
    clone->Alias_stmts(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Clocking_blocks()) {
    auto clone_vec = context->m_serializer->MakeClocking_blockVec();
    clone->Clocking_blocks(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Task_funcs()) {
    auto clone_vec = context->m_serializer->MakeTask_funcVec();
    clone->Task_funcs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Elab_tasks()) {
    auto clone_vec = context->m_serializer->MakeTf_callVec();
    clone->Elab_tasks(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveGen_scope(clone, nullptr);
}

gen_scope* gen_scope::DeepClone(BaseClass* parent, CloneContext* context) const {
  gen_scope* const clone = context->m_serializer->MakeGen_scope();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t gen_scope::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->VpiIndex(), rhs->VpiIndex(), context)) != 0) return r;
  if ((r = (lhs->VpiArrayMember() == rhs->VpiArrayMember()) ? 0 : (lhs->VpiArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiProtected() == rhs->VpiProtected()) ? 0 : (lhs->VpiProtected() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiImplicitDecl() == rhs->VpiImplicitDecl()) ? 0 : (lhs->VpiImplicitDecl() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Nets(), rhs, rhs->Nets(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Array_nets(), rhs, rhs->Array_nets(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Process(), rhs, rhs->Process(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Cont_assigns(), rhs, rhs->Cont_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Modules(), rhs, rhs->Modules(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Module_arrays(), rhs, rhs->Module_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Primitives(), rhs, rhs->Primitives(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Primitive_arrays(), rhs, rhs->Primitive_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Def_params(), rhs, rhs->Def_params(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Gen_scope_arrays(), rhs, rhs->Gen_scope_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Programs(), rhs, rhs->Programs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Program_arrays(), rhs, rhs->Program_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Assertions(), rhs, rhs->Assertions(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Interfaces(), rhs, rhs->Interfaces(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Interface_arrays(), rhs, rhs->Interface_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Alias_stmts(), rhs, rhs->Alias_stmts(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Clocking_blocks(), rhs, rhs->Clocking_blocks(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Task_funcs(), rhs, rhs->Task_funcs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Elab_tasks(), rhs, rhs->Elab_tasks(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
