/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   gen_scope_array.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/gen_scope_array.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/gen_scope.h>
#include <uhdm/gen_var.h>
#include <uhdm/interf_prog_mod_group.h>


namespace UHDM {
std::string_view gen_scope_array::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool gen_scope_array::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view gen_scope_array::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<gen_scope_array*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool gen_scope_array::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* gen_scope_array::GetByVpiName(std::string_view name) const {
  if ((gen_var_ != nullptr) && (gen_var_->VpiName().compare(name) == 0)) {
    return gen_var_;
  }
  if (gen_scopes_ != nullptr) {
    for (const BaseClass *ref : *gen_scopes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((vpiInstance_ != nullptr) && (vpiInstance_->VpiName().compare(name) == 0)) {
    return vpiInstance_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> gen_scope_array::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiGenScope: return std::make_tuple(nullptr, uhdmgen_scopes, (const std::vector<const BaseClass*>*)gen_scopes_);
    case vpiGenVar: return std::make_tuple(gen_var_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInstance: return std::make_tuple(vpiInstance_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

gen_scope_array::vpi_property_value_t gen_scope_array::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiSize: return vpi_property_value_t(VpiSize());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void gen_scope_array::DeepCopy(gen_scope_array* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterGen_scope_array(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Gen_var()) clone->Gen_var(obj->DeepClone(clone, context));
  if (auto vec = Gen_scopes()) {
    auto clone_vec = context->m_serializer->MakeGen_scopeVec();
    clone->Gen_scopes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = VpiInstance()) clone->VpiInstance(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveGen_scope_array(clone, nullptr);
}

int32_t gen_scope_array::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiSize() - rhs->VpiSize()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Gen_var(), rhs->Gen_var(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Gen_scopes(), rhs, rhs->Gen_scopes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiInstance(), rhs->VpiInstance(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
