/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   if_else.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/if_else.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* if_else::GetByVpiName(std::string_view name) const {
  if ((vpiCondition_ != nullptr) && (vpiCondition_->VpiName().compare(name) == 0)) {
    return vpiCondition_;
  }
  if ((vpiStmt_ != nullptr) && (vpiStmt_->VpiName().compare(name) == 0)) {
    return vpiStmt_;
  }
  if ((vpiElseStmt_ != nullptr) && (vpiElseStmt_->VpiName().compare(name) == 0)) {
    return vpiElseStmt_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> if_else::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCondition: return std::make_tuple(vpiCondition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiElseStmt: return std::make_tuple(vpiElseStmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(vpiStmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

if_else::vpi_property_value_t if_else::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiQualifier: return vpi_property_value_t(VpiQualifier());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void if_else::DeepCopy(if_else* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterIf_else(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiCondition()) clone->VpiCondition(obj->DeepClone(clone, context));
  if (auto obj = VpiStmt()) clone->VpiStmt(obj->DeepClone(clone, context));
  if (auto obj = VpiElseStmt()) clone->VpiElseStmt(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveIf_else(clone, nullptr);
}

if_else* if_else::DeepClone(BaseClass* parent, CloneContext* context) const {
  if_else* const clone = context->m_serializer->MakeIf_else();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t if_else::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiQualifier() - rhs->VpiQualifier()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->VpiCondition(), rhs->VpiCondition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiStmt(), rhs->VpiStmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiElseStmt(), rhs->VpiElseStmt(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
