/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   immediate_assert.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/immediate_assert.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>
#include <uhdm/expr.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* immediate_assert::GetByVpiName(std::string_view name) const {
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if ((stmt_ != nullptr) && (stmt_->VpiName().compare(name) == 0)) {
    return stmt_;
  }
  if ((else_stmt_ != nullptr) && (else_stmt_->VpiName().compare(name) == 0)) {
    return else_stmt_;
  }
  if ((clocking_block_ != nullptr) && (clocking_block_->VpiName().compare(name) == 0)) {
    return clocking_block_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> immediate_assert::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClockingBlock: return std::make_tuple(clocking_block_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiElseStmt: return std::make_tuple(else_stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

immediate_assert::vpi_property_value_t immediate_assert::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiIsDeferred: return vpi_property_value_t(VpiIsDeferred());
    case vpiIsFinal: return vpi_property_value_t(VpiIsFinal());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void immediate_assert::DeepCopy(immediate_assert* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterImmediate_assert(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  if (auto obj = Else_stmt()) clone->Else_stmt(obj->DeepClone(clone, context));
  if (auto obj = Clocking_block()) clone->Clocking_block(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveImmediate_assert(clone, nullptr);
}

immediate_assert* immediate_assert::DeepClone(BaseClass* parent, CloneContext* context) const {
  immediate_assert* const clone = context->m_serializer->MakeImmediate_assert();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t immediate_assert::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiIsDeferred() - rhs->VpiIsDeferred()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiIsFinal() - rhs->VpiIsFinal()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Stmt(), rhs->Stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Else_stmt(), rhs->Else_stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Clocking_block(), rhs->Clocking_block(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
