/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   include_file_info.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/include_file_info.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>


namespace UHDM {
std::string_view include_file_info::VpiIncludedFile() const {
  return vpiIncludedFile_ ? serializer_->GetSymbol(vpiIncludedFile_) : kEmpty;
}

bool include_file_info::VpiIncludedFile(std::string_view data) {
  vpiIncludedFile_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* include_file_info::GetByVpiName(std::string_view name) const {
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> include_file_info::GetByVpiType(int32_t type) const {
  switch (type) {
  }
  return basetype_t::GetByVpiType(type);
}

include_file_info::vpi_property_value_t include_file_info::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiIncludedFile: {
      std::string_view data = VpiIncludedFile();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void include_file_info::DeepCopy(include_file_info* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterInclude_file_info(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  elaboratorContext->m_elaborator.leaveInclude_file_info(clone, nullptr);
}

include_file_info* include_file_info::DeepClone(BaseClass* parent, CloneContext* context) const {
  include_file_info* const clone = context->m_serializer->MakeInclude_file_info();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t include_file_info::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  return r;
}

}  // namespace UHDM
