/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   instance.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/instance.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/array_net.h>
#include <uhdm/assertion.h>
#include <uhdm/class_defn.h>
#include <uhdm/instance.h>
#include <uhdm/module_inst.h>
#include <uhdm/net.h>
#include <uhdm/program.h>
#include <uhdm/spec_param.h>
#include <uhdm/task_func.h>


namespace UHDM {
std::string_view instance::VpiDefName() const {
  return vpiDefName_ ? serializer_->GetSymbol(vpiDefName_) : kEmpty;
}

bool instance::VpiDefName(std::string_view data) {
  vpiDefName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view instance::VpiDefFile() const {
  return vpiDefFile_ ? serializer_->GetSymbol(vpiDefFile_) : kEmpty;
}

bool instance::VpiDefFile(std::string_view data) {
  vpiDefFile_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view instance::VpiLibrary() const {
  return vpiLibrary_ ? serializer_->GetSymbol(vpiLibrary_) : kEmpty;
}

bool instance::VpiLibrary(std::string_view data) {
  vpiLibrary_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view instance::VpiCell() const {
  return vpiCell_ ? serializer_->GetSymbol(vpiCell_) : kEmpty;
}

bool instance::VpiCell(std::string_view data) {
  vpiCell_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view instance::VpiConfig() const {
  return vpiConfig_ ? serializer_->GetSymbol(vpiConfig_) : kEmpty;
}

bool instance::VpiConfig(std::string_view data) {
  vpiConfig_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* instance::GetByVpiName(std::string_view name) const {
  if (programs_ != nullptr) {
    for (const BaseClass *ref : *programs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (program_arrays_ != nullptr) {
    for (const BaseClass *ref : *program_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (class_defns_ != nullptr) {
    for (const BaseClass *ref : *class_defns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (task_funcs_ != nullptr) {
    for (const BaseClass *ref : *task_funcs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (nets_ != nullptr) {
    for (const BaseClass *ref : *nets_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (array_nets_ != nullptr) {
    for (const BaseClass *ref : *array_nets_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (spec_params_ != nullptr) {
    for (const BaseClass *ref : *spec_params_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (assertions_ != nullptr) {
    for (const BaseClass *ref : *assertions_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((module_inst_ != nullptr) && (module_inst_->VpiName().compare(name) == 0)) {
    return module_inst_;
  }
  if ((instance_ != nullptr) && (instance_->VpiName().compare(name) == 0)) {
    return instance_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> instance::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiArrayNet: return std::make_tuple(nullptr, uhdmarray_nets, (const std::vector<const BaseClass*>*)array_nets_);
    case vpiAssertion: return std::make_tuple(nullptr, uhdmassertions, (const std::vector<const BaseClass*>*)assertions_);
    case vpiClassDefn: return std::make_tuple(nullptr, uhdmclass_defns, (const std::vector<const BaseClass*>*)class_defns_);
    case vpiInstance: return std::make_tuple(instance_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiModule: return std::make_tuple(module_inst_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiNet: return std::make_tuple(nullptr, uhdmnets, (const std::vector<const BaseClass*>*)nets_);
    case vpiProgram: return std::make_tuple(nullptr, uhdmprograms, (const std::vector<const BaseClass*>*)programs_);
    case vpiProgramArray: return std::make_tuple(nullptr, uhdmprogram_arrays, (const std::vector<const BaseClass*>*)program_arrays_);
    case vpiSpecParam: return std::make_tuple(nullptr, uhdmspec_params, (const std::vector<const BaseClass*>*)spec_params_);
    case vpiTaskFunc: return std::make_tuple(nullptr, uhdmtask_funcs, (const std::vector<const BaseClass*>*)task_funcs_);
  }
  return basetype_t::GetByVpiType(type);
}

instance::vpi_property_value_t instance::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiArrayMember: return vpi_property_value_t(VpiArrayMember());
    case vpiAutomatic: return vpi_property_value_t(VpiAutomatic());
    case vpiCell: {
      std::string_view data = VpiCell();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiCellInstance: return vpi_property_value_t(VpiCellInstance());
    case vpiConfig: {
      std::string_view data = VpiConfig();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiDefDelayMode: return vpi_property_value_t(VpiDefDelayMode());
    case vpiDefFile: {
      std::string_view data = VpiDefFile();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiDefLineNo: return vpi_property_value_t(VpiDefLineNo());
    case vpiDefName: {
      std::string_view data = VpiDefName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiDefNetType: return vpi_property_value_t(VpiDefNetType());
    case vpiLibrary: {
      std::string_view data = VpiLibrary();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiProtected: return vpi_property_value_t(VpiProtected());
    case vpiTimePrecision: return vpi_property_value_t(VpiTimePrecision());
    case vpiTimeUnit: return vpi_property_value_t(VpiTimeUnit());
    case vpiTop: return vpi_property_value_t(VpiTop());
    case vpiUnconnDrive: return vpi_property_value_t(VpiUnconnDrive());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void instance::DeepCopy(instance* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Programs()) {
    auto clone_vec = context->m_serializer->MakeProgramVec();
    clone->Programs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Program_arrays()) {
    auto clone_vec = context->m_serializer->MakeProgramVec();
    clone->Program_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Class_defns()) {
    auto clone_vec = context->m_serializer->MakeClass_defnVec();
    clone->Class_defns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Task_funcs()) {
    auto clone_vec = context->m_serializer->MakeTask_funcVec();
    clone->Task_funcs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Nets()) {
    auto clone_vec = context->m_serializer->MakeNetVec();
    clone->Nets(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_nets()) {
    auto clone_vec = context->m_serializer->MakeArray_netVec();
    clone->Array_nets(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Spec_params()) {
    auto clone_vec = context->m_serializer->MakeSpec_paramVec();
    clone->Spec_params(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Assertions()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Assertions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Module_inst()) clone->Module_inst((module_inst*) obj);
  if (auto obj = Instance()) clone->Instance((instance*) obj);
  if (instance* inst = any_cast<instance*>(parent))
    clone->Instance(inst);
}

int32_t instance::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiDefName().compare(rhs->VpiDefName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiArrayMember() == rhs->VpiArrayMember()) ? 0 : (lhs->VpiArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiCellInstance() == rhs->VpiCellInstance()) ? 0 : (lhs->VpiCellInstance() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDefNetType() - rhs->VpiDefNetType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDefDelayMode() - rhs->VpiDefDelayMode()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiProtected() == rhs->VpiProtected()) ? 0 : (lhs->VpiProtected() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiTimePrecision() - rhs->VpiTimePrecision()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiTimeUnit() - rhs->VpiTimeUnit()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiUnconnDrive() - rhs->VpiUnconnDrive()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiLibrary().compare(rhs->VpiLibrary())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiCell().compare(rhs->VpiCell())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiConfig().compare(rhs->VpiConfig())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiAutomatic() == rhs->VpiAutomatic()) ? 0 : (lhs->VpiAutomatic() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiTop() == rhs->VpiTop()) ? 0 : (lhs->VpiTop() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Programs(), rhs, rhs->Programs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Program_arrays(), rhs, rhs->Program_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Class_defns(), rhs, rhs->Class_defns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Task_funcs(), rhs, rhs->Task_funcs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Nets(), rhs, rhs->Nets(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Array_nets(), rhs, rhs->Array_nets(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Spec_params(), rhs, rhs->Spec_params(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Assertions(), rhs, rhs->Assertions(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Module_inst(), rhs->Module_inst(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Instance(), rhs->Instance(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
