/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   instance_array.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/instance_array.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/instance.h>
#include <uhdm/module_inst.h>
#include <uhdm/port.h>
#include <uhdm/range.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
std::string_view instance_array::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool instance_array::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view instance_array::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<instance_array*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool instance_array::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* instance_array::GetByVpiName(std::string_view name) const {
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if (ranges_ != nullptr) {
    for (const BaseClass *ref : *ranges_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((left_expr_ != nullptr) && (left_expr_->VpiName().compare(name) == 0)) {
    return left_expr_;
  }
  if ((right_expr_ != nullptr) && (right_expr_->VpiName().compare(name) == 0)) {
    return right_expr_;
  }
  if (instances_ != nullptr) {
    for (const BaseClass *ref : *instances_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (modules_ != nullptr) {
    for (const BaseClass *ref : *modules_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((elem_typespec_ != nullptr) && (elem_typespec_->VpiName().compare(name) == 0)) {
    return elem_typespec_;
  }
  if (ports_ != nullptr) {
    for (const BaseClass *ref : *ports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> instance_array::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiElemTypespec: return std::make_tuple(elem_typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInstance: return std::make_tuple(nullptr, uhdminstances, (const std::vector<const BaseClass*>*)instances_);
    case vpiLeftRange: return std::make_tuple(left_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiModule: return std::make_tuple(nullptr, uhdmmodules, (const std::vector<const BaseClass*>*)modules_);
    case vpiPort: return std::make_tuple(nullptr, uhdmports, (const std::vector<const BaseClass*>*)ports_);
    case vpiRange: return std::make_tuple(nullptr, uhdmranges, (const std::vector<const BaseClass*>*)ranges_);
    case vpiRightRange: return std::make_tuple(right_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

instance_array::vpi_property_value_t instance_array::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiSize: return vpi_property_value_t(VpiSize());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void instance_array::DeepCopy(instance_array* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto vec = Ranges()) {
    auto clone_vec = context->m_serializer->MakeRangeVec();
    clone->Ranges(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Left_expr()) clone->Left_expr(obj->DeepClone(clone, context));
  if (auto obj = Right_expr()) clone->Right_expr(obj->DeepClone(clone, context));
  if (auto vec = Instances()) {
    auto clone_vec = context->m_serializer->MakeInstanceVec();
    clone->Instances(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Modules()) {
    auto clone_vec = context->m_serializer->MakeModule_instVec();
    clone->Modules(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Elem_typespec()) clone->Elem_typespec(obj->DeepClone(clone, context));
  if (auto vec = Ports()) {
    auto clone_vec = context->m_serializer->MakePortVec();
    clone->Ports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t instance_array::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiSize() - rhs->VpiSize()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ranges(), rhs, rhs->Ranges(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Left_expr(), rhs->Left_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_expr(), rhs->Right_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Instances(), rhs, rhs->Instances(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Modules(), rhs, rhs->Modules(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Elem_typespec(), rhs->Elem_typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ports(), rhs, rhs->Ports(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
