/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   instance_item.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/instance_item.h>

#include <iostream>
#include <uhdm/uhdm.h>

namespace UHDM {
bool instance_itemGroupCompliant(const any* item) {
  if (item == nullptr) {
    return true;
  }
  UHDM_OBJECT_TYPE uhdmtype = item->UhdmType();
  if ((uhdmtype != uhdmarray_net) &&
      (uhdmtype != uhdmarray_typespec) &&
      (uhdmtype != uhdmarray_var) &&
      (uhdmtype != uhdmassert_stmt) &&
      (uhdmtype != uhdmassertion) &&
      (uhdmtype != uhdmassume) &&
      (uhdmtype != uhdmbit_typespec) &&
      (uhdmtype != uhdmbit_var) &&
      (uhdmtype != uhdmbyte_typespec) &&
      (uhdmtype != uhdmbyte_var) &&
      (uhdmtype != uhdmchandle_typespec) &&
      (uhdmtype != uhdmchandle_var) &&
      (uhdmtype != uhdmchecker_inst) &&
      (uhdmtype != uhdmclass_defn) &&
      (uhdmtype != uhdmclass_typespec) &&
      (uhdmtype != uhdmclass_var) &&
      (uhdmtype != uhdmcover) &&
      (uhdmtype != uhdmenum_net) &&
      (uhdmtype != uhdmenum_typespec) &&
      (uhdmtype != uhdmenum_var) &&
      (uhdmtype != uhdmevent_typespec) &&
      (uhdmtype != uhdmfunction) &&
      (uhdmtype != uhdmimmediate_assert) &&
      (uhdmtype != uhdmimmediate_assume) &&
      (uhdmtype != uhdmimmediate_cover) &&
      (uhdmtype != uhdmimport_typespec) &&
      (uhdmtype != uhdmint_typespec) &&
      (uhdmtype != uhdmint_var) &&
      (uhdmtype != uhdminteger_net) &&
      (uhdmtype != uhdminteger_typespec) &&
      (uhdmtype != uhdminteger_var) &&
      (uhdmtype != uhdminterface_typespec) &&
      (uhdmtype != uhdmlogic_net) &&
      (uhdmtype != uhdmlogic_typespec) &&
      (uhdmtype != uhdmlogic_var) &&
      (uhdmtype != uhdmlong_int_typespec) &&
      (uhdmtype != uhdmlong_int_var) &&
      (uhdmtype != uhdmmodule_typespec) &&
      (uhdmtype != uhdmnamed_event) &&
      (uhdmtype != uhdmnamed_event_array) &&
      (uhdmtype != uhdmnet) &&
      (uhdmtype != uhdmpacked_array_net) &&
      (uhdmtype != uhdmpacked_array_typespec) &&
      (uhdmtype != uhdmpacked_array_var) &&
      (uhdmtype != uhdmparameter) &&
      (uhdmtype != uhdmparameters) &&
      (uhdmtype != uhdmprogram) &&
      (uhdmtype != uhdmprogram_array) &&
      (uhdmtype != uhdmproperty_inst) &&
      (uhdmtype != uhdmproperty_typespec) &&
      (uhdmtype != uhdmreal_typespec) &&
      (uhdmtype != uhdmreal_var) &&
      (uhdmtype != uhdmref_var) &&
      (uhdmtype != uhdmrestrict) &&
      (uhdmtype != uhdmsequence_inst) &&
      (uhdmtype != uhdmsequence_typespec) &&
      (uhdmtype != uhdmshort_int_typespec) &&
      (uhdmtype != uhdmshort_int_var) &&
      (uhdmtype != uhdmshort_real_typespec) &&
      (uhdmtype != uhdmshort_real_var) &&
      (uhdmtype != uhdmspec_param) &&
      (uhdmtype != uhdmstring_typespec) &&
      (uhdmtype != uhdmstring_var) &&
      (uhdmtype != uhdmstruct_net) &&
      (uhdmtype != uhdmstruct_typespec) &&
      (uhdmtype != uhdmstruct_var) &&
      (uhdmtype != uhdmtask) &&
      (uhdmtype != uhdmtask_func) &&
      (uhdmtype != uhdmtime_net) &&
      (uhdmtype != uhdmtime_typespec) &&
      (uhdmtype != uhdmtime_var) &&
      (uhdmtype != uhdmtype_parameter) &&
      (uhdmtype != uhdmtypespec) &&
      (uhdmtype != uhdmunion_typespec) &&
      (uhdmtype != uhdmunion_var) &&
      (uhdmtype != uhdmunsupported_typespec) &&
      (uhdmtype != uhdmvar_bit) &&
      (uhdmtype != uhdmvariables) &&
      (uhdmtype != uhdmvoid_typespec)) {
    item->GetSerializer()->GetErrorHandler()(ErrorType::UHDM_WRONG_OBJECT_TYPE, "Internal Error: adding wrong object type (" + UhdmName(uhdmtype) + ") in a instance_item group!", item, nullptr);
    return false;
  }
  return true;
}

bool instance_itemGroupCompliant(const VectorOfany* vec) {
  if (vec != nullptr) {
    for (auto item : *vec) {
      if (!instance_itemGroupCompliant(item)) {
        return false;
      }
    }
  }
  return true;
}

}  // namespace UHDM
