/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   integer_typespec.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/integer_typespec.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>


namespace UHDM {
std::string_view integer_typespec::VpiValue() const {
  return vpiValue_ ? serializer_->GetSymbol(vpiValue_) : kEmpty;
}

bool integer_typespec::VpiValue(std::string_view data) {
  vpiValue_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* integer_typespec::GetByVpiName(std::string_view name) const {
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> integer_typespec::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

integer_typespec::vpi_property_value_t integer_typespec::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiSigned: return vpi_property_value_t(VpiSigned());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void integer_typespec::DeepCopy(integer_typespec* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterInteger_typespec(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveInteger_typespec(clone, nullptr);
}

integer_typespec* integer_typespec::DeepClone(BaseClass* parent, CloneContext* context) const {
  integer_typespec* const clone = context->m_serializer->MakeInteger_typespec();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t integer_typespec::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = (lhs->VpiSigned() == rhs->VpiSigned()) ? 0 : (lhs->VpiSigned() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
