/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   interface_inst.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/interface_inst.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>
#include <uhdm/cont_assign.h>
#include <uhdm/expr_dist.h>
#include <uhdm/gen_scope_array.h>
#include <uhdm/gen_stmt.h>
#include <uhdm/instance_array.h>
#include <uhdm/interface_array.h>
#include <uhdm/interface_inst.h>
#include <uhdm/interface_tf_decl.h>
#include <uhdm/mod_path.h>
#include <uhdm/modport.h>
#include <uhdm/port.h>
#include <uhdm/process_stmt.h>
#include <uhdm/tf_call.h>


namespace UHDM {
std::string_view interface_inst::VpiEndLabel() const {
  return vpiEndLabel_ ? serializer_->GetSymbol(vpiEndLabel_) : kEmpty;
}

bool interface_inst::VpiEndLabel(std::string_view data) {
  vpiEndLabel_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* interface_inst::GetByVpiName(std::string_view name) const {
  if (interface_tf_decls_ != nullptr) {
    for (const BaseClass *ref : *interface_tf_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (modports_ != nullptr) {
    for (const BaseClass *ref : *modports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((global_clocking_ != nullptr) && (global_clocking_->VpiName().compare(name) == 0)) {
    return global_clocking_;
  }
  if ((default_clocking_ != nullptr) && (default_clocking_->VpiName().compare(name) == 0)) {
    return default_clocking_;
  }
  if ((expr_dist_ != nullptr) && (expr_dist_->VpiName().compare(name) == 0)) {
    return expr_dist_;
  }
  if ((instance_array_ != nullptr) && (instance_array_->VpiName().compare(name) == 0)) {
    return instance_array_;
  }
  if (mod_paths_ != nullptr) {
    for (const BaseClass *ref : *mod_paths_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (cont_assigns_ != nullptr) {
    for (const BaseClass *ref : *cont_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (clocking_blocks_ != nullptr) {
    for (const BaseClass *ref : *clocking_blocks_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (interfaces_ != nullptr) {
    for (const BaseClass *ref : *interfaces_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (interface_arrays_ != nullptr) {
    for (const BaseClass *ref : *interface_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (process_ != nullptr) {
    for (const BaseClass *ref : *process_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (ports_ != nullptr) {
    for (const BaseClass *ref : *ports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (gen_scope_arrays_ != nullptr) {
    for (const BaseClass *ref : *gen_scope_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (elab_tasks_ != nullptr) {
    for (const BaseClass *ref : *elab_tasks_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (gen_stmts_ != nullptr) {
    for (const BaseClass *ref : *gen_stmts_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> interface_inst::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClockingBlock: return std::make_tuple(nullptr, uhdmclocking_blocks, (const std::vector<const BaseClass*>*)clocking_blocks_);
    case vpiContAssign: return std::make_tuple(nullptr, uhdmcont_assigns, (const std::vector<const BaseClass*>*)cont_assigns_);
    case vpiDefaultClocking: return std::make_tuple(default_clocking_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiDefaultDisableIff: return std::make_tuple(expr_dist_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiGenScopeArray: return std::make_tuple(nullptr, uhdmgen_scope_arrays, (const std::vector<const BaseClass*>*)gen_scope_arrays_);
    case vpiGenStmt: return std::make_tuple(nullptr, uhdmgen_stmts, (const std::vector<const BaseClass*>*)gen_stmts_);
    case vpiGlobalClocking: return std::make_tuple(global_clocking_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInstanceArray: return std::make_tuple(instance_array_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInterface: return std::make_tuple(nullptr, uhdminterfaces, (const std::vector<const BaseClass*>*)interfaces_);
    case vpiInterfaceArray: return std::make_tuple(nullptr, uhdminterface_arrays, (const std::vector<const BaseClass*>*)interface_arrays_);
    case vpiInterfaceTfDecl: return std::make_tuple(nullptr, uhdminterface_tf_decls, (const std::vector<const BaseClass*>*)interface_tf_decls_);
    case vpiModPath: return std::make_tuple(nullptr, uhdmmod_paths, (const std::vector<const BaseClass*>*)mod_paths_);
    case vpiModport: return std::make_tuple(nullptr, uhdmmodports, (const std::vector<const BaseClass*>*)modports_);
    case vpiPort: return std::make_tuple(nullptr, uhdmports, (const std::vector<const BaseClass*>*)ports_);
    case vpiProcess: return std::make_tuple(nullptr, uhdmprocess, (const std::vector<const BaseClass*>*)process_);
    case vpiSysTaskCall: return std::make_tuple(nullptr, uhdmelab_tasks, (const std::vector<const BaseClass*>*)elab_tasks_);
  }
  return basetype_t::GetByVpiType(type);
}

interface_inst::vpi_property_value_t interface_inst::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiEndLabel: {
      std::string_view data = VpiEndLabel();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiIndex: return vpi_property_value_t(VpiIndex());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void interface_inst::DeepCopy(interface_inst* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterInterface_inst(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Interface_tf_decls()) {
    auto clone_vec = context->m_serializer->MakeInterface_tf_declVec();
    clone->Interface_tf_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Modports()) {
    auto clone_vec = context->m_serializer->MakeModportVec();
    clone->Modports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Global_clocking()) clone->Global_clocking(obj->DeepClone(clone, context));
  if (auto obj = Default_clocking()) clone->Default_clocking(obj->DeepClone(clone, context));
  if (auto obj = Expr_dist()) clone->Expr_dist(obj->DeepClone(clone, context));
  if (auto obj = Instance_array()) clone->Instance_array(obj->DeepClone(clone, context));
  if (auto vec = Mod_paths()) {
    auto clone_vec = context->m_serializer->MakeMod_pathVec();
    clone->Mod_paths(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Cont_assigns()) {
    auto clone_vec = context->m_serializer->MakeCont_assignVec();
    clone->Cont_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Clocking_blocks()) {
    auto clone_vec = context->m_serializer->MakeClocking_blockVec();
    clone->Clocking_blocks(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Interfaces()) {
    auto clone_vec = context->m_serializer->MakeInterface_instVec();
    clone->Interfaces(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Interface_arrays()) {
    auto clone_vec = context->m_serializer->MakeInterface_arrayVec();
    clone->Interface_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Process()) {
    auto clone_vec = context->m_serializer->MakeProcess_stmtVec();
    clone->Process(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Ports()) {
    auto clone_vec = context->m_serializer->MakePortVec();
    clone->Ports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Gen_scope_arrays()) {
    auto clone_vec = context->m_serializer->MakeGen_scope_arrayVec();
    clone->Gen_scope_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Elab_tasks()) {
    auto clone_vec = context->m_serializer->MakeTf_callVec();
    clone->Elab_tasks(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Gen_stmts()) {
    auto clone_vec = context->m_serializer->MakeGen_stmtVec();
    clone->Gen_stmts(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveInterface_inst(clone, nullptr);
}

interface_inst* interface_inst::DeepClone(BaseClass* parent, CloneContext* context) const {
  interface_inst* const clone = context->m_serializer->MakeInterface_inst();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t interface_inst::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiIndex() - rhs->VpiIndex()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Interface_tf_decls(), rhs, rhs->Interface_tf_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Modports(), rhs, rhs->Modports(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Global_clocking(), rhs->Global_clocking(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Default_clocking(), rhs->Default_clocking(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr_dist(), rhs->Expr_dist(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Instance_array(), rhs->Instance_array(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Mod_paths(), rhs, rhs->Mod_paths(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Cont_assigns(), rhs, rhs->Cont_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Clocking_blocks(), rhs, rhs->Clocking_blocks(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Interfaces(), rhs, rhs->Interfaces(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Interface_arrays(), rhs, rhs->Interface_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Process(), rhs, rhs->Process(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ports(), rhs, rhs->Ports(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Gen_scope_arrays(), rhs, rhs->Gen_scope_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Elab_tasks(), rhs, rhs->Elab_tasks(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Gen_stmts(), rhs, rhs->Gen_stmts(), context)) != 0) return r;
  if ((r = lhs->VpiEndLabel().compare(rhs->VpiEndLabel())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
