/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   interface_tf_decl.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/interface_tf_decl.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/function.h>
#include <uhdm/task.h>


namespace UHDM {
const BaseClass* interface_tf_decl::GetByVpiName(std::string_view name) const {
  if (tasks_ != nullptr) {
    for (const BaseClass *ref : *tasks_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (functions_ != nullptr) {
    for (const BaseClass *ref : *functions_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> interface_tf_decl::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiFunction: return std::make_tuple(nullptr, uhdmfunctions, (const std::vector<const BaseClass*>*)functions_);
    case vpiTask: return std::make_tuple(nullptr, uhdmtasks, (const std::vector<const BaseClass*>*)tasks_);
  }
  return basetype_t::GetByVpiType(type);
}

interface_tf_decl::vpi_property_value_t interface_tf_decl::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiAccessType: return vpi_property_value_t(VpiAccessType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void interface_tf_decl::DeepCopy(interface_tf_decl* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterInterface_tf_decl(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Tasks()) {
    auto clone_vec = context->m_serializer->MakeTaskVec();
    clone->Tasks(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Functions()) {
    auto clone_vec = context->m_serializer->MakeFunctionVec();
    clone->Functions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveInterface_tf_decl(clone, nullptr);
}

interface_tf_decl* interface_tf_decl::DeepClone(BaseClass* parent, CloneContext* context) const {
  interface_tf_decl* const clone = context->m_serializer->MakeInterface_tf_decl();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t interface_tf_decl::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiAccessType() - rhs->VpiAccessType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Tasks(), rhs, rhs->Tasks(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Functions(), rhs, rhs->Functions(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
