/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   interface_typespec.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/interface_typespec.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/param_assign.h>


namespace UHDM {
std::string_view interface_typespec::VpiDefName() const {
  return vpiDefName_ ? serializer_->GetSymbol(vpiDefName_) : kEmpty;
}

bool interface_typespec::VpiDefName(std::string_view data) {
  vpiDefName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* interface_typespec::GetByVpiName(std::string_view name) const {
  if (param_assigns_ != nullptr) {
    for (const BaseClass *ref : *param_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> interface_typespec::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiParamAssign: return std::make_tuple(nullptr, uhdmparam_assigns, (const std::vector<const BaseClass*>*)param_assigns_);
  }
  return basetype_t::GetByVpiType(type);
}

interface_typespec::vpi_property_value_t interface_typespec::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDefName: {
      std::string_view data = VpiDefName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiIsModPort: return vpi_property_value_t(VpiIsModPort());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void interface_typespec::DeepCopy(interface_typespec* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterInterface_typespec(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Param_assigns()) {
    auto clone_vec = context->m_serializer->MakeParam_assignVec();
    clone->Param_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveInterface_typespec(clone, nullptr);
}

interface_typespec* interface_typespec::DeepClone(BaseClass* parent, CloneContext* context) const {
  interface_typespec* const clone = context->m_serializer->MakeInterface_typespec();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t interface_typespec::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiDefName().compare(rhs->VpiDefName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiIsModPort() == rhs->VpiIsModPort()) ? 0 : (lhs->VpiIsModPort() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Param_assigns(), rhs, rhs->Param_assigns(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
