/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   io_decl.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/io_decl.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/range.h>
#include <uhdm/ref_obj_interf_net_var_group.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
std::string_view io_decl::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool io_decl::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* io_decl::GetByVpiName(std::string_view name) const {
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if ((left_expr_ != nullptr) && (left_expr_->VpiName().compare(name) == 0)) {
    return left_expr_;
  }
  if ((right_expr_ != nullptr) && (right_expr_->VpiName().compare(name) == 0)) {
    return right_expr_;
  }
  if (ranges_ != nullptr) {
    for (const BaseClass *ref : *ranges_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((typespec_ != nullptr) && (typespec_->VpiName().compare(name) == 0)) {
    return typespec_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> io_decl::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLeftRange: return std::make_tuple(left_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRange: return std::make_tuple(nullptr, uhdmranges, (const std::vector<const BaseClass*>*)ranges_);
    case vpiRightRange: return std::make_tuple(right_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTypedef: return std::make_tuple(typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

io_decl::vpi_property_value_t io_decl::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDirection: return vpi_property_value_t(VpiDirection());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiScalar: return vpi_property_value_t(VpiScalar());
    case vpiSigned: return vpi_property_value_t(VpiSigned());
    case vpiSize: return vpi_property_value_t(VpiSize());
    case vpiType: return vpi_property_value_t(VpiType());
    case vpiVector: return vpi_property_value_t(VpiVector());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void io_decl::DeepCopy(io_decl* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterIo_decl(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto obj = Left_expr()) clone->Left_expr(obj->DeepClone(clone, context));
  if (auto obj = Right_expr()) clone->Right_expr(obj->DeepClone(clone, context));
  if (auto vec = Ranges()) {
    auto clone_vec = context->m_serializer->MakeRangeVec();
    clone->Ranges(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveIo_decl(clone, nullptr);
}

io_decl* io_decl::DeepClone(BaseClass* parent, CloneContext* context) const {
  io_decl* const clone = context->m_serializer->MakeIo_decl();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t io_decl::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDirection() - rhs->VpiDirection()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiScalar() == rhs->VpiScalar()) ? 0 : (lhs->VpiScalar() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiSigned() == rhs->VpiSigned()) ? 0 : (lhs->VpiSigned() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiSize() - rhs->VpiSize()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiVector() == rhs->VpiVector()) ? 0 : (lhs->VpiVector() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Left_expr(), rhs->Left_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_expr(), rhs->Right_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ranges(), rhs, rhs->Ranges(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Typespec(), rhs->Typespec(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
