/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   let_decl.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/let_decl.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/seq_formal_decl.h>


namespace UHDM {
std::string_view let_decl::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool let_decl::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* let_decl::GetByVpiName(std::string_view name) const {
  if (expressions_ != nullptr) {
    for (const BaseClass *ref : *expressions_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (seq_formal_decls_ != nullptr) {
    for (const BaseClass *ref : *seq_formal_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> let_decl::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(nullptr, uhdmexpressions, (const std::vector<const BaseClass*>*)expressions_);
    case vpiSeqFormalDecl: return std::make_tuple(nullptr, uhdmseq_formal_decls, (const std::vector<const BaseClass*>*)seq_formal_decls_);
  }
  return basetype_t::GetByVpiType(type);
}

let_decl::vpi_property_value_t let_decl::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void let_decl::DeepCopy(let_decl* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterLet_decl(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Expressions()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Expressions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Seq_formal_decls()) {
    auto clone_vec = context->m_serializer->MakeSeq_formal_declVec();
    clone->Seq_formal_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveLet_decl(clone, nullptr);
}

let_decl* let_decl::DeepClone(BaseClass* parent, CloneContext* context) const {
  let_decl* const clone = context->m_serializer->MakeLet_decl();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t let_decl::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->Expressions(), rhs, rhs->Expressions(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Seq_formal_decls(), rhs, rhs->Seq_formal_decls(), context)) != 0) return r;
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
