/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   let_expr.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/let_expr.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/let_decl.h>


namespace UHDM {
const BaseClass* let_expr::GetByVpiName(std::string_view name) const {
  if (arguments_ != nullptr) {
    for (const BaseClass *ref : *arguments_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((let_decl_ != nullptr) && (let_decl_->VpiName().compare(name) == 0)) {
    return let_decl_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> let_expr::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiArgument: return std::make_tuple(nullptr, uhdmarguments, (const std::vector<const BaseClass*>*)arguments_);
    case vpiLetDecl: return std::make_tuple(let_decl_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

let_expr::vpi_property_value_t let_expr::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void let_expr::DeepCopy(let_expr* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterLet_expr(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Arguments()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Arguments(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Let_decl()) clone->Let_decl(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveLet_expr(clone, nullptr);
}

let_expr* let_expr::DeepClone(BaseClass* parent, CloneContext* context) const {
  let_expr* const clone = context->m_serializer->MakeLet_expr();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t let_expr::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->Arguments(), rhs, rhs->Arguments(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Let_decl(), rhs->Let_decl(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
