/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   modport.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/modport.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/interface_inst.h>
#include <uhdm/io_decl.h>
#include <uhdm/module_inst.h>


namespace UHDM {
std::string_view modport::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool modport::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* modport::GetByVpiName(std::string_view name) const {
  if (io_decls_ != nullptr) {
    for (const BaseClass *ref : *io_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((interface_inst_ != nullptr) && (interface_inst_->VpiName().compare(name) == 0)) {
    return interface_inst_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> modport::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiIODecl: return std::make_tuple(nullptr, uhdmio_decls, (const std::vector<const BaseClass*>*)io_decls_);
    case vpiInterface: return std::make_tuple(interface_inst_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

modport::vpi_property_value_t modport::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void modport::DeepCopy(modport* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterModport(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Io_decls()) {
    auto clone_vec = context->m_serializer->MakeIo_declVec();
    clone->Io_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Interface_inst()) clone->Interface_inst((interface_inst*) obj);
  elaboratorContext->m_elaborator.leaveModport(clone, nullptr);
}

modport* modport::DeepClone(BaseClass* parent, CloneContext* context) const {
  modport* const clone = context->m_serializer->MakeModport();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t modport::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Io_decls(), rhs, rhs->Io_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Interface_inst(), rhs->Interface_inst(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
