/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   multiclock_sequence_expr.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/multiclock_sequence_expr.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocked_seq.h>


namespace UHDM {
const BaseClass* multiclock_sequence_expr::GetByVpiName(std::string_view name) const {
  if (clocked_seqs_ != nullptr) {
    for (const BaseClass *ref : *clocked_seqs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> multiclock_sequence_expr::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClockedSeq: return std::make_tuple(nullptr, uhdmclocked_seqs, (const std::vector<const BaseClass*>*)clocked_seqs_);
  }
  return basetype_t::GetByVpiType(type);
}

multiclock_sequence_expr::vpi_property_value_t multiclock_sequence_expr::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void multiclock_sequence_expr::DeepCopy(multiclock_sequence_expr* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterMulticlock_sequence_expr(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Clocked_seqs()) {
    auto clone_vec = context->m_serializer->MakeClocked_seqVec();
    clone->Clocked_seqs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveMulticlock_sequence_expr(clone, nullptr);
}

multiclock_sequence_expr* multiclock_sequence_expr::DeepClone(BaseClass* parent, CloneContext* context) const {
  multiclock_sequence_expr* const clone = context->m_serializer->MakeMulticlock_sequence_expr();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t multiclock_sequence_expr::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->Clocked_seqs(), rhs, rhs->Clocked_seqs(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
