/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   named_event.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/named_event.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/ref_typespec.h>
#include <uhdm/thread_obj.h>


namespace UHDM {
std::string_view named_event::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool named_event::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view named_event::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<named_event*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool named_event::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view named_event::VpiEndLabel() const {
  return vpiEndLabel_ ? serializer_->GetSymbol(vpiEndLabel_) : kEmpty;
}

bool named_event::VpiEndLabel(std::string_view data) {
  vpiEndLabel_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* named_event::GetByVpiName(std::string_view name) const {
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((event_typespec_ != nullptr) && (event_typespec_->VpiName().compare(name) == 0)) {
    return event_typespec_;
  }
  if (threads_ != nullptr) {
    for (const BaseClass *ref : *threads_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> named_event::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiTypespec: return std::make_tuple(event_typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiWaitingProcesses: return std::make_tuple(nullptr, uhdmthreads, (const std::vector<const BaseClass*>*)threads_);
  }
  return basetype_t::GetByVpiType(type);
}

named_event::vpi_property_value_t named_event::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiAllocScheme: return vpi_property_value_t(VpiAllocScheme());
    case vpiArrayMember: return vpi_property_value_t(VpiArrayMember());
    case vpiAutomatic: return vpi_property_value_t(VpiAutomatic());
    case vpiEndLabel: {
      std::string_view data = VpiEndLabel();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void named_event::DeepCopy(named_event* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterNamed_event(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Event_typespec()) clone->Event_typespec(obj->DeepClone(clone, context));
  if (auto vec = Threads()) {
    auto clone_vec = context->m_serializer->MakeThread_objVec();
    clone->Threads(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveNamed_event(clone, nullptr);
}

named_event* named_event::DeepClone(BaseClass* parent, CloneContext* context) const {
  named_event* const clone = context->m_serializer->MakeNamed_event();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t named_event::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiArrayMember() == rhs->VpiArrayMember()) ? 0 : (lhs->VpiArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiAutomatic() == rhs->VpiAutomatic()) ? 0 : (lhs->VpiAutomatic() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiAllocScheme() - rhs->VpiAllocScheme()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Event_typespec(), rhs->Event_typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Threads(), rhs, rhs->Threads(), context)) != 0) return r;
  if ((r = lhs->VpiEndLabel().compare(rhs->VpiEndLabel())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
