/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   net.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/net.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/expr.h>
#include <uhdm/net_bit.h>


namespace UHDM {
const BaseClass* net::GetByVpiName(std::string_view name) const {
  if (net_bits_ != nullptr) {
    for (const BaseClass *ref : *net_bits_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (exprs_ != nullptr) {
    for (const BaseClass *ref : *exprs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> net::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiBit: return std::make_tuple(nullptr, uhdmnet_bits, (const std::vector<const BaseClass*>*)net_bits_);
    case vpiIndex: return std::make_tuple(nullptr, uhdmexprs, (const std::vector<const BaseClass*>*)exprs_);
  }
  return basetype_t::GetByVpiType(type);
}

net::vpi_property_value_t net::GetVpiPropertyValue(int32_t property) const {
  return basetype_t::GetVpiPropertyValue(property);
}

void net::DeepCopy(net* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Net_bits()) {
    auto clone_vec = context->m_serializer->MakeNet_bitVec();
    clone->Net_bits(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Exprs()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Exprs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t net::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->Net_bits(), rhs, rhs->Net_bits(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Exprs(), rhs, rhs->Exprs(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
